"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleEventLogListTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../constants");
var _event_log = require("../../common/components/event_log");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _rule_action_error_log_flyout = require("./rule_action_error_log_flyout");
var _refine_search_prompt = require("../../common/components/refine_search_prompt");
var _rules_list_doc_link = require("../../rules_list/components/rules_list_doc_link");
var _rule_event_log_list_kpi = require("./rule_event_log_list_kpi");
var _use_multiple_spaces = require("../../../hooks/use_multiple_spaces");
var _use_load_rule_event_logs = require("../../../hooks/use_load_rule_event_logs");
var _rules_settings_link = require("../../../components/rules_setting/rules_settings_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_event_log_list_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const API_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.apiError', {
  defaultMessage: 'Failed to fetch execution history'
});
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.searchPlaceholder', {
  defaultMessage: 'Search event log message'
});
const RULE_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.ruleEventLogList.initialColumns';
const getDefaultColumns = columns => {
  const columnsWithoutLockedColumn = columns.filter(column => !_constants.LOCKED_COLUMNS.includes(column));
  return [..._constants.LOCKED_COLUMNS, ...columnsWithoutLockedColumn];
};
const ALL_SPACES_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.ruleEventLogList.showAllSpacesToggle', {
  defaultMessage: 'Show rules from all spaces'
});
const updateButtonProps = {
  iconOnly: true,
  fill: false
};
const MAX_RESULTS = 1000;
const RuleEventLogListTable = props => {
  const {
    ruleId,
    localStorageKey = RULE_EVENT_LOG_LIST_STORAGE_KEY,
    refreshToken,
    initialPageSize = 10,
    hasRuleNames = false,
    hasAllSpaceSwitch = false,
    setHeaderActions,
    filteredRuleTypes,
    getRuleDetailsRoute
  } = props;
  const {
    uiSettings,
    notifications
  } = (0, _kibana.useKibana)().services;
  const [searchText, setSearchText] = (0, _react.useState)('');
  const [search, setSearch] = (0, _react.useState)('');
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [selectedRunLog, setSelectedRunLog] = (0, _react.useState)();
  const [internalRefreshToken, setInternalRefreshToken] = (0, _react.useState)(refreshToken);
  const [showFromAllSpaces, setShowFromAllSpaces] = (0, _react.useState)(false);

  // Data grid states
  const [logs, setLogs] = (0, _react.useState)();
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(() => {
    var _localStorage$getItem;
    return getDefaultColumns(JSON.parse((_localStorage$getItem = localStorage.getItem(localStorageKey)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : 'null') || hasRuleNames ? _constants.GLOBAL_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS : _constants.RULE_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS);
  });
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const [filter, setFilter] = (0, _react.useState)([]);
  const [actualTotalItemCount, setActualTotalItemCount] = (0, _react.useState)(0);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: initialPageSize,
    totalItemCount: 0
  });

  // Date related states
  const [dateStart, setDateStart] = (0, _react.useState)('now-15m');
  const [dateEnd, setDateEnd] = (0, _react.useState)('now');
  const [dateFormat] = (0, _react.useState)(() => uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat'));
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get;
    return (uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get('timepicker:quickRanges')) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => ({
      start: from,
      end: to,
      label: display
    }))) || [];
  });
  const {
    onShowAllSpacesChange,
    canAccessMultipleSpaces,
    namespaces,
    activeSpace
  } = (0, _use_multiple_spaces.useMultipleSpaces)({
    setShowFromAllSpaces,
    showFromAllSpaces,
    visibleColumns,
    setVisibleColumns
  });
  const isInitialized = (0, _react.useRef)(false);
  const isOnLastPage = (0, _react.useMemo)(() => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return (pageIndex + 1) * pageSize >= MAX_RESULTS;
  }, [pagination]);

  // Formats the sort columns to be consumed by the API endpoint
  const formattedSort = (0, _react.useMemo)(() => {
    return sortingColumns.map(({
      id: sortId,
      direction
    }) => ({
      [sortId]: {
        order: direction
      }
    }));
  }, [sortingColumns]);
  (0, _react.useEffect)(() => {
    setHeaderActions === null || setHeaderActions === void 0 ? void 0 : setHeaderActions([/*#__PURE__*/_react.default.createElement(_rules_settings_link.RulesSettingsLink, {
      alertDeleteCategoryIds: ['management', 'observability', 'securitySolution'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_list_doc_link.RulesListDocLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 7
      }
    })]);
    return () => setHeaderActions === null || setHeaderActions === void 0 ? void 0 : setHeaderActions();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onError = (0, _react.useCallback)(e => {
    var _e$body, _e$body$message, _e$body2;
    if (((_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.statusCode) === 413) {
      return;
    }
    notifications.toasts.addDanger({
      title: API_FAILED_MESSAGE,
      text: (_e$body$message = (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message) !== null && _e$body$message !== void 0 ? _e$body$message : e
    });
  }, [notifications]);
  const {
    data,
    isLoading,
    hasExceedLogs,
    loadEventLogs
  } = (0, _use_load_rule_event_logs.useLoadRuleEventLogs)({
    id: ruleId,
    sort: formattedSort,
    outcomeFilter: filter,
    message: searchText,
    dateStart,
    dateEnd,
    page: pagination.pageIndex,
    perPage: pagination.pageSize,
    namespaces,
    ruleTypeIds: filteredRuleTypes,
    onError
  });
  (0, _react.useEffect)(() => {
    if (!data) {
      return;
    }
    setPagination(prevPagination => ({
      ...prevPagination,
      totalItemCount: Math.min(data.total, MAX_RESULTS)
    }));
    setLogs(data.data);
    setActualTotalItemCount(data.total);
  }, [data]);
  const getPaginatedRowIndex = (0, _react.useCallback)(rowIndex => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return rowIndex - pageIndex * pageSize;
  }, [pagination]);
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex: 0,
      pageSize
    }));
  }, [setPagination]);
  const onChangePage = (0, _react.useCallback)(pageIndex => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex
    }));
  }, [setPagination]);
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (isInvalid) {
      return;
    }
    setDateStart(start);
    setDateEnd(end);
  }, [setDateStart, setDateEnd]);
  const onRefresh = () => {
    setInternalRefreshToken({
      resolve: () => {
        /* noop */
      },
      reject: () => {
        /* noop */
      }
    });
    loadEventLogs();
  };
  const onFilterChange = (0, _react.useCallback)(newFilter => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex: 0
    }));
    setFilter(newFilter);
  }, [setPagination, setFilter]);
  const onFlyoutOpen = (0, _react.useCallback)(runLog => {
    setIsFlyoutOpen(true);
    setSelectedRunLog(runLog);
  }, []);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsFlyoutOpen(false);
    setSelectedRunLog(undefined);
  }, []);
  const onSearchChange = (0, _react.useCallback)(e => {
    if (e.target.value === '') {
      setSearchText('');
    }
    setSearch(e.target.value);
  }, [setSearchText, setSearch]);
  const onKeyUp = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      setSearchText(search);
    }
  }, [search, setSearchText]);
  const columns = (0, _react.useMemo)(() => [...(hasRuleNames ? [{
    id: 'rule_id',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.ruleId', {
      defaultMessage: 'Rule Id'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('rule_id'),
    actions: {
      showSortAsc: false,
      showSortDesc: false
    }
  }, {
    id: 'rule_name',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.ruleName', {
      defaultMessage: 'Rule'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('rule_name'),
    actions: {
      showSortAsc: false,
      showSortDesc: false,
      showHide: false
    }
  }] : []), ...(showFromAllSpaces ? [{
    id: 'space_ids',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.spaceIds', {
      defaultMessage: 'Space'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('space_ids'),
    actions: {
      showSortAsc: false,
      showSortDesc: false,
      showHide: false
    }
  }] : []), {
    id: 'id',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.id', {
      defaultMessage: 'Id'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('id')
  }, {
    id: 'timestamp',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.timestamp', {
      defaultMessage: 'Timestamp'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('timestamp'),
    isResizable: false,
    actions: {
      showHide: false
    },
    initialWidth: 250
  }, {
    id: 'execution_duration',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.duration', {
      defaultMessage: 'Duration'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('execution_duration'),
    isResizable: false,
    actions: {
      showHide: false
    },
    initialWidth: 100
  }, {
    id: 'status',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.response', {
      defaultMessage: 'Response'
    }),
    actions: {
      showHide: false,
      showSortAsc: false,
      showSortDesc: false,
      additional: [{
        iconType: 'annotation',
        label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.showOnlyFailures', {
          defaultMessage: 'Show only failures'
        }),
        onClick: () => onFilterChange(['failure']),
        size: 'xs'
      }, {
        iconType: 'annotation',
        label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.showAll', {
          defaultMessage: 'Show all'
        }),
        onClick: () => onFilterChange([]),
        size: 'xs'
      }]
    },
    isSortable: (0, _event_log.getIsColumnSortable)('status'),
    isResizable: false,
    initialWidth: 150
  }, {
    id: 'message',
    actions: {
      showSortAsc: false,
      showSortDesc: false
    },
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.message', {
      defaultMessage: 'Message'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('message'),
    cellActions: [({
      rowIndex,
      Component
    }) => {
      const pagedRowIndex = getPaginatedRowIndex(rowIndex);
      const eventLog = logs || [];
      const runLog = eventLog[pagedRowIndex];
      const actionErrors = runLog === null || runLog === void 0 ? void 0 : runLog.num_errored_actions;
      if (actionErrors) {
        return /*#__PURE__*/_react.default.createElement(Component, {
          onClick: () => onFlyoutOpen(runLog),
          iconType: "warning",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 490,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.viewActionErrors",
          defaultMessage: "View action errors",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 491,
            columnNumber: 19
          }
        }));
      }
      return null;
    }]
  }, {
    id: 'num_active_alerts',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.activeAlerts', {
      defaultMessage: 'Active alerts'
    }),
    initialWidth: 140,
    isSortable: (0, _event_log.getIsColumnSortable)('num_active_alerts')
  }, {
    id: 'num_new_alerts',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.newAlerts', {
      defaultMessage: 'New alerts'
    }),
    initialWidth: 140,
    isSortable: (0, _event_log.getIsColumnSortable)('num_new_alerts')
  }, {
    id: 'num_recovered_alerts',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.recoveredAlerts', {
      defaultMessage: 'Recovered alerts'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('num_recovered_alerts')
  }, {
    id: 'num_triggered_actions',
    displayAsText: _event_log.numTriggeredActionsDisplay,
    display: /*#__PURE__*/_react.default.createElement(_event_log.ColumnHeaderWithToolTip, {
      id: "num_triggered_actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 537,
        columnNumber: 18
      }
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('num_triggered_actions')
  }, {
    id: 'num_generated_actions',
    displayAsText: _event_log.numGeneratedActionsDisplay,
    display: /*#__PURE__*/_react.default.createElement(_event_log.ColumnHeaderWithToolTip, {
      id: "num_generated_actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 543,
        columnNumber: 18
      }
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('num_generated_actions')
  }, {
    id: 'num_succeeded_actions',
    displayAsText: _event_log.numSucceededActionsDisplay,
    display: /*#__PURE__*/_react.default.createElement(_event_log.ColumnHeaderWithToolTip, {
      id: "num_succeeded_actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 549,
        columnNumber: 18
      }
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('num_succeeded_actions')
  }, {
    id: 'num_errored_actions',
    actions: {
      showSortAsc: false,
      showSortDesc: false
    },
    displayAsText: _event_log.numErroredActionsDisplay,
    display: /*#__PURE__*/_react.default.createElement(_event_log.ColumnHeaderWithToolTip, {
      id: "num_errored_actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 559,
        columnNumber: 18
      }
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('num_errored_actions')
  }, {
    id: 'total_search_duration',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.totalSearchDuration', {
      defaultMessage: 'Total search duration'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('total_search_duration')
  }, {
    id: 'es_search_duration',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.esSearchDuration', {
      defaultMessage: 'ES search duration'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('es_search_duration')
  }, {
    id: 'schedule_delay',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.scheduleDelay', {
      defaultMessage: 'Schedule delay'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('schedule_delay')
  }, {
    id: 'timed_out',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.timedOut', {
      defaultMessage: 'Timed out'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('timed_out')
  }, {
    id: 'maintenance_window_ids',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.eventLogColumn.maintenanceWindowIds', {
      defaultMessage: 'Maintenance windows'
    }),
    actions: {
      showSortAsc: false,
      showSortDesc: false
    },
    isSortable: (0, _event_log.getIsColumnSortable)('maintenance_window_ids')
  }], [getPaginatedRowIndex, onFlyoutOpen, onFilterChange, hasRuleNames, showFromAllSpaces, logs]);
  const renderList = () => {
    if (!logs) {
      return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 622,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent",
      "data-test-subj": "ruleEventLogListProgressBar",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 627,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_event_log.EventLogDataGrid, {
      columns: columns,
      logs: logs,
      pagination: pagination,
      sortingColumns: sortingColumns,
      visibleColumns: visibleColumns,
      dateFormat: dateFormat,
      selectedRunLog: selectedRunLog,
      onChangeItemsPerPage: onChangeItemsPerPage,
      onChangePage: onChangePage,
      onFlyoutOpen: onFlyoutOpen,
      setVisibleColumns: setVisibleColumns,
      setSortingColumns: setSortingColumns,
      getRuleDetailsRoute: getRuleDetailsRoute,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 629,
        columnNumber: 9
      }
    }));
  };
  (0, _react.useEffect)(() => {
    loadEventLogs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sortingColumns, dateStart, dateEnd, filter, pagination.pageIndex, pagination.pageSize, searchText, showFromAllSpaces]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadEventLogs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  (0, _react.useEffect)(() => {
    localStorage.setItem(localStorageKey, JSON.stringify(visibleColumns));
  }, [localStorageKey, visibleColumns]);
  (0, _react.useEffect)(() => {
    setInternalRefreshToken(refreshToken);
  }, [refreshToken]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    "data-test-subj": "ruleEventLogListTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 679,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 680,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 681,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 682,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    isClearable: true,
    value: search,
    onChange: onSearchChange,
    onKeyUp: onKeyUp,
    placeholder: SEARCH_PLACEHOLDER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 683,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 692,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatusFilter, {
    selectedOptions: filter,
    onChange: onFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 693,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 695,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": "ruleEventLogListDatePicker",
    width: "auto",
    isLoading: isLoading,
    start: dateStart,
    end: dateEnd,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    dateFormat: dateFormat,
    commonlyUsedRanges: commonlyUsedRanges,
    updateButtonProps: updateButtonProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 696,
      columnNumber: 13
    }
  })), hasAllSpaceSwitch && canAccessMultipleSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "showAllSpacesSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 710,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: ALL_SPACES_LABEL,
    checked: showFromAllSpaces,
    onChange: onShowAllSpacesChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 711,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 719,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 721,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_event_log_list_kpi.RuleEventLogListKPIWithApi, {
    ruleId: ruleId,
    dateStart: dateStart,
    dateEnd: dateEnd,
    outcomeFilter: filter,
    message: searchText,
    refreshToken: internalRefreshToken,
    namespaces: namespaces,
    filteredRuleTypes: filteredRuleTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 722,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 732,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 734,
      columnNumber: 7
    }
  }, hasExceedLogs && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.exceedLog.refineSearch.prompt",
      defaultMessage: "Results are limited to 10,000 documents, refine your search to see others.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 738,
        columnNumber: 15
      }
    }),
    "data-test-subj": "exceedLimitLogsCallout",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 736,
      columnNumber: 11
    }
  }), !hasExceedLogs && renderList(), isOnLastPage && /*#__PURE__*/_react.default.createElement(_refine_search_prompt.RefineSearchPrompt, {
    documentSize: actualTotalItemCount,
    visibleDocumentSize: MAX_RESULTS,
    backToTopAnchor: "rule_event_log_list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 749,
      columnNumber: 11
    }
  })), isFlyoutOpen && selectedRunLog && /*#__PURE__*/_react.default.createElement(_rule_action_error_log_flyout.RuleActionErrorLogFlyout, {
    runLog: selectedRunLog,
    refreshToken: refreshToken,
    onClose: onFlyoutClose,
    activeSpaceId: activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 757,
      columnNumber: 9
    }
  }));
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleEventLogListTable = RuleEventLogListTable;