"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleComponent = RuleComponent;
exports.RuleWithApi = void 0;
exports.alertToListItem = alertToListItem;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _configuration = require("@kbn/response-ops-alerts-table/configuration");
var _kibana = require("../../../../common/lib/kibana");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _suspended_component_with_props = require("../../../lib/suspended_component_with_props");
var _rule_status_helpers = require("../../../../common/lib/rule_status_helpers");
var _rule_status_panel = _interopRequireDefault(require("./rule_status_panel"));
var _translations = require("../../rules_list/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleEventLogList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./rule_event_log_list'))));
const RuleAlertList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./rule_alert_list'))));
const RuleDefinition = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./rule_definition'))));
const AlertsTable = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/response-ops-alerts-table'))));
const EVENT_LOG_LIST_TAB = 'rule_event_log_list';
const ALERT_LIST_TAB = 'rule_alert_list';

// We don't want to show the Feature column in the rule page
const alertsTableColumns = [_configuration.defaultAlertsTableColumns[0], ..._configuration.defaultAlertsTableColumns.slice(2)];
function RuleComponent({
  rule,
  ruleType,
  readOnly,
  ruleSummary,
  muteAlertInstance,
  unmuteAlertInstance,
  requestRefresh,
  refreshToken,
  numberOfExecutions,
  onChangeDuration,
  durationEpoch = Date.now(),
  isLoadingChart
}) {
  const {
    ruleTypeRegistry,
    actionTypeRegistry,
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  } = (0, _kibana.useKibana)().services;
  // The lastReloadRequestTime should be updated when the refreshToken changes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const lastReloadRequestTime = (0, _react.useMemo)(() => new Date().getTime(), [refreshToken]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const alerts = Object.entries(ruleSummary.alerts).map(([alertId, alert]) => alertToListItem(durationEpoch, alertId, alert)).sort((leftAlert, rightAlert) => leftAlert.sortPriority - rightAlert.sortPriority);
  const onMuteAction = (0, _react.useCallback)(async alert => {
    await (alert.isMuted ? unmuteAlertInstance(rule, alert.alert) : muteAlertInstance(rule, alert.alert));
    requestRefresh();
  }, [muteAlertInstance, requestRefresh, rule, unmuteAlertInstance]);
  const healthColor = (0, _rule_status_helpers.getRuleHealthColor)(rule, euiTheme);
  const statusMessage = (0, _rule_status_helpers.getRuleStatusMessage)({
    rule,
    licenseErrorText: _translations.ALERT_STATUS_LICENSE_ERROR,
    lastOutcomeTranslations: _translations.rulesLastRunOutcomeTranslationMapping,
    executionStatusTranslations: _translations.rulesStatusesTranslationsMapping
  });
  const renderRuleAlertList = (0, _react.useCallback)(() => {
    if (ruleType.hasAlertsMappings) {
      return /*#__PURE__*/_react.default.createElement(AlertsTable, {
        id: "rule-detail-alerts-table",
        ruleTypeIds: [ruleType.id],
        query: {
          bool: {
            filter: {
              term: {
                [_ruleDataUtils.ALERT_RULE_UUID]: rule.id
              }
            }
          }
        },
        showAlertStatusWithFlapping: true,
        columns: alertsTableColumns,
        lastReloadRequestTime: lastReloadRequestTime,
        services: {
          data,
          http,
          notifications,
          fieldFormats,
          application,
          licensing,
          settings
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 9
        }
      });
    }
    return (0, _suspended_component_with_props.suspendedComponentWithProps)(RuleAlertList, 'xl')({
      items: alerts,
      readOnly,
      onMuteAction
    });
  }, [alerts, application, data, fieldFormats, http, lastReloadRequestTime, licensing, notifications, onMuteAction, readOnly, rule.id, ruleType.hasAlertsMappings, ruleType.id, settings]);
  const tabs = [{
    id: ALERT_LIST_TAB,
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.rule.alertsTabText', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'ruleAlertListTab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }), renderRuleAlertList())
  }, {
    id: EVENT_LOG_LIST_TAB,
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.rule.eventLogTabText', {
      defaultMessage: 'History'
    }),
    'data-test-subj': 'eventLogListTab',
    content: (0, _suspended_component_with_props.suspendedComponentWithProps)(RuleEventLogList, 'xl')({
      fetchRuleSummary: false,
      ruleId: rule.id,
      ruleType,
      ruleSummary,
      numberOfExecutions,
      refreshToken,
      isLoadingRuleSummary: isLoadingChart,
      onChangeDuration,
      requestRefresh
    })
  }];
  const renderTabs = () => {
    const isEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('rulesDetailLogs');
    if (isEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
        "data-test-subj": "ruleDetailsTabbedContent",
        tabs: tabs,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 14
        }
      });
    }
    return renderRuleAlertList();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_status_panel.default, {
    rule: rule,
    isEditable: !readOnly,
    healthColor: healthColor,
    statusMessage: statusMessage,
    requestRefresh: requestRefresh,
    refreshToken: refreshToken,
    autoRecoverAlerts: ruleType.autoRecoverAlerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), (0, _suspended_component_with_props.suspendedComponentWithProps)(RuleDefinition, 'xl')({
    rule,
    actionTypeRegistry,
    ruleTypeRegistry,
    hideEditButton: true,
    onEditRule: requestRefresh
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("input", {
    type: "hidden",
    "data-test-subj": "alertsDurationEpoch",
    name: "alertsDurationEpoch",
    value: durationEpoch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), renderTabs());
}
const RuleWithApi = exports.RuleWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleComponent);
function alertToListItem(durationEpoch, alertId, alert) {
  const isMuted = !!(alert !== null && alert !== void 0 && alert.muted);
  const status = alert.status;
  const start = alert !== null && alert !== void 0 && alert.activeStartDate ? new Date(alert.activeStartDate) : undefined;
  const duration = start ? durationEpoch - start.valueOf() : 0;
  const sortPriority = getSortPriorityByStatus(alert === null || alert === void 0 ? void 0 : alert.status);
  const tracked = !!(alert !== null && alert !== void 0 && alert.tracked);
  return {
    alert: alertId,
    status,
    start,
    duration,
    isMuted,
    sortPriority,
    flapping: alert.flapping,
    tracked,
    ...(alert.maintenanceWindowIds ? {
      maintenanceWindowIds: alert.maintenanceWindowIds
    } : {})
  };
}
function getSortPriorityByStatus(status) {
  switch (status) {
    case 'Active':
      return 0;
    case 'OK':
      return 1;
  }
  return 2;
}