"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleQuickEditButtonsWithApi = exports.RuleQuickEditButtons = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("./with_bulk_rule_api_operations");
var _kibana = require("../../../../common/lib/kibana");
var _untrack_alerts_modal = require("./untrack_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/rule_quick_edit_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleQuickEditButtons = ({
  selectedItems,
  isAllSelected = false,
  getFilter,
  onPerformingAction = noop,
  onActionPerformed = noop,
  bulkEditAction,
  isEnablingRules = false,
  isDisablingRules = false,
  isBulkEditing = false,
  updateRulesToBulkEdit,
  onEnable,
  onDisable
}) => {
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [isUntrackAlertsModalOpen, setIsUntrackAlertsModalOpen] = (0, _react.useState)(false);
  const isPerformingAction = isEnablingRules || isDisablingRules || isBulkEditing;
  const hasDisabledByLicenseRuleTypes = (0, _react.useMemo)(() => {
    if (isAllSelected) {
      return false;
    }
    return !!selectedItems.find(alertItem => !alertItem.enabledInLicense);
  }, [selectedItems, isAllSelected]);
  const hasAutoRecoverAlertsRuleTypes = (0, _react.useMemo)(() => {
    if (isAllSelected) {
      // Show "untrack active alerts" confirmation modal if all alerts are selected
      return true;
    }
    return !!selectedItems.find(alertItem => alertItem.autoRecoverAlerts !== false);
  }, [isAllSelected, selectedItems]);
  async function deleteSelectedItems() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'delete',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'delete',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToDeleteRulesMessage', {
          defaultMessage: 'Failed to delete rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function updateAPIKeysClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'updateApiKey',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'updateApiKey',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToUpdateRuleAPIKeysMessage', {
          defaultMessage: 'Failed to update API keys for rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onSnoozeAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'snooze',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'snooze',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onUnsnoozeAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'unsnooze',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'unsnooze',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onScheduleAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'schedule',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'schedule',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onUnscheduleAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'unschedule',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'unschedule',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  const onDisableClick = (0, _react.useCallback)(() => {
    if (hasAutoRecoverAlertsRuleTypes) {
      setIsUntrackAlertsModalOpen(true);
    } else {
      onDisable(false);
    }
  }, [hasAutoRecoverAlertsRuleTypes, onDisable]);
  const onModalClose = (0, _react.useCallback)(() => {
    setIsUntrackAlertsModalOpen(false);
  }, []);
  const onModalConfirm = (0, _react.useCallback)(untrack => {
    onModalClose();
    onDisable(untrack);
  }, [onModalClose, onDisable]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    direction: "column",
    gutterSize: "none",
    "data-test-subj": "ruleQuickEditButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }, !isAllSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onSnoozeAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'snooze',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkSnooze",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.snoozeAllTitle",
    defaultMessage: "Snooze now",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUnsnoozeAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'unsnooze',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkUnsnooze",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.unsnoozeAllTitle",
    defaultMessage: "Unsnooze now",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onScheduleAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'schedule',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkSnoozeSchedule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.snoozeScheduleAllTitle",
    defaultMessage: "Schedule snooze",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUnscheduleAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'unschedule',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkRemoveSnoozeSchedule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.removeSnoozeScheduleAllTitle",
    defaultMessage: "Unschedule snooze",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onEnable,
    isLoading: isEnablingRules,
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkEnable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.enableAllTitle",
    defaultMessage: "Enable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDisableClick,
    isLoading: isDisablingRules,
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkDisable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.disableAllTitle",
    defaultMessage: "Disable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: updateAPIKeysClick,
    isLoading: isBulkEditing && bulkEditAction === 'updateApiKey',
    isDisabled: isPerformingAction,
    "data-test-subj": "updateAPIKeys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.updateRuleAPIKeysTitle",
    defaultMessage: "Update API keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: deleteSelectedItems,
    isLoading: isBulkEditing && bulkEditAction === 'delete',
    iconType: "trash",
    color: "danger",
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkDelete",
    className: "actBulkActionPopover__deleteAll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.deleteAllTitle",
    defaultMessage: "Delete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 13
    }
  })))), isUntrackAlertsModalOpen && /*#__PURE__*/_react.default.createElement(_untrack_alerts_modal.UntrackAlertsModal, {
    onConfirm: onModalConfirm,
    onCancel: onModalClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 9
    }
  }));
};
exports.RuleQuickEditButtons = RuleQuickEditButtons;
const RuleQuickEditButtonsWithApi = exports.RuleQuickEditButtonsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleQuickEditButtons);
function noop() {}