"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numTriggeredActionsDisplay = exports.numSucceededActionsDisplay = exports.numGeneratedActionsDisplay = exports.numErroredActionsDisplay = exports.getIsColumnSortable = exports.EventLogDataGrid = exports.ColumnHeaderWithToolTip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("@kbn/alerting-plugin/common");
var _lodash = require("lodash");
var _get_experimental_features = require("../../../../../common/get_experimental_features");
var _ = require(".");
var _rule_action_error_badge = require("../../../rule_details/components/rule_action_error_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/event_log/event_log_data_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getIsColumnSortable = columnId => {
  return _common.executionLogSortableColumns.includes(columnId);
};
exports.getIsColumnSortable = getIsColumnSortable;
const getErroredActionsTranslation = errors => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogDataGrid.erroredActionsTooltip', {
    defaultMessage: '{value, plural, one {# errored action} other {# errored actions}}',
    values: {
      value: errors
    }
  });
};
const PAGE_SIZE_OPTIONS = [10, 50, 100];
const numTriggeredActionsDisplay = exports.numTriggeredActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.triggeredActions', {
  defaultMessage: 'Triggered actions'
});
const numTriggeredActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.triggeredActionsToolTip', {
  defaultMessage: 'The subset of generated actions that will run.'
});
const numGeneratedActionsDisplay = exports.numGeneratedActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.scheduledActions', {
  defaultMessage: 'Generated actions'
});
const numGeneratedActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.scheduledActionsToolTip', {
  defaultMessage: 'The total number of actions generated when the rule ran.'
});
const numSucceededActionsDisplay = exports.numSucceededActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.succeededActions', {
  defaultMessage: 'Succeeded actions'
});
const numSucceededActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.succeededActionsToolTip', {
  defaultMessage: 'The number of actions that were completed successfully.'
});
const numErroredActionsDisplay = exports.numErroredActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.erroredActions', {
  defaultMessage: 'Errored actions'
});
const numErroredActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.erroredActionsToolTip', {
  defaultMessage: 'The number of failed actions.'
});
const columnsWithToolTipMap = {
  num_triggered_actions: {
    display: numTriggeredActionsDisplay,
    toolTip: numTriggeredActionsToolTip
  },
  num_generated_actions: {
    display: numGeneratedActionsDisplay,
    toolTip: numGeneratedActionsToolTip
  },
  num_succeeded_actions: {
    display: numSucceededActionsDisplay,
    toolTip: numSucceededActionsToolTip
  },
  num_errored_actions: {
    display: numErroredActionsDisplay,
    toolTip: numErroredActionsToolTip
  }
};
const ColumnHeaderWithToolTip = ({
  id
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    style: {
      display: 'inline-flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, columnsWithToolTipMap[id].display), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: columnsWithToolTipMap[id].toolTip,
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  })));
};
exports.ColumnHeaderWithToolTip = ColumnHeaderWithToolTip;
const EventLogDataGrid = props => {
  const {
    columns,
    logs = [],
    sortingColumns,
    pageSizeOptions = PAGE_SIZE_OPTIONS,
    pagination,
    dateFormat,
    visibleColumns,
    selectedRunLog,
    setVisibleColumns,
    setSortingColumns,
    onChangeItemsPerPage,
    onChangePage,
    onFlyoutOpen,
    getRuleDetailsRoute
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedRowCss = (0, _react2.css)`
    background-color: ${euiTheme.colors.highlight};
  `;
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const getPaginatedRowIndex = (0, _react.useCallback)(rowIndex => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return rowIndex - pageIndex * pageSize;
  }, [pagination]);
  const columnVisibilityProps = (0, _react.useMemo)(() => {
    return {
      visibleColumns,
      setVisibleColumns
    };
  }, [visibleColumns, setVisibleColumns]);
  const sortingProps = (0, _react.useMemo)(() => ({
    onSort: setSortingColumns,
    columns: sortingColumns
  }), [setSortingColumns, sortingColumns]);
  const paginationProps = (0, _react.useMemo)(() => ({
    ...pagination,
    pageSizeOptions,
    onChangeItemsPerPage,
    onChangePage
  }), [pagination, pageSizeOptions, onChangeItemsPerPage, onChangePage]);
  const rowClasses = (0, _react.useMemo)(() => {
    if (!selectedRunLog) {
      return {};
    }
    const index = logs.findIndex(log => log.id === selectedRunLog.id);
    return {
      [index]: 'ruleEventLogDataGrid--rowClassSelected'
    };
  }, [selectedRunLog, logs]);
  const gridStyles = (0, _react.useMemo)(() => {
    return {
      border: 'horizontal',
      header: 'underline',
      rowClasses
    };
  }, [rowClasses]);
  const renderMessageWithActionError = (columnId, errors, showTooltip = false) => {
    if (columnId !== 'message') {
      return null;
    }
    if (!errors) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 7
      }
    }, showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: getErroredActionsTranslation(errors),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_action_error_badge.RuleActionErrorBadge, {
      totalErrors: errors,
      showIcon: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement(_rule_action_error_badge.RuleActionErrorBadge, {
      totalErrors: errors,
      showIcon: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 11
      }
    }));
  };

  // Renders the cell popover for runs with errored actions
  const renderCellPopover = cellPopoverProps => {
    const {
      columnId,
      rowIndex,
      cellActions,
      DefaultCellPopover
    } = cellPopoverProps;
    if (columnId !== 'message') {
      return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, (0, _extends2.default)({}, cellPopoverProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 14
        }
      }));
    }
    const pagedRowIndex = getPaginatedRowIndex(rowIndex);
    const runLog = logs[pagedRowIndex];
    if (!runLog) {
      return null;
    }
    const value = runLog[columnId];
    const actionErrors = (0, _lodash.get)(runLog, 'num_errored_actions', 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 11
      }
    }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }), actionErrors > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 15
      }
    }, renderMessageWithActionError(columnId, actionErrors)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 15
      }
    }, "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.eventLogDataGrid.erroredActionsCellPopover",
      defaultMessage: "{value, plural, one {errored action} other {errored actions}}",
      values: {
        value: actionErrors
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 13
      }
    }), cellActions));
  };

  // Main cell renderer, renders durations, statuses, etc.
  const renderCell = ({
    rowIndex,
    columnId
  }) => {
    var _logs$pagedRowIndex, _logs$pagedRowIndex2;
    const pagedRowIndex = getPaginatedRowIndex(rowIndex);
    const runLog = logs[pagedRowIndex];
    const value = (_logs$pagedRowIndex = logs[pagedRowIndex]) === null || _logs$pagedRowIndex === void 0 ? void 0 : _logs$pagedRowIndex[columnId];
    const actionErrors = (0, _lodash.get)(logs[pagedRowIndex], 'num_errored_actions', 0);
    const version = logs === null || logs === void 0 ? void 0 : (_logs$pagedRowIndex2 = logs[pagedRowIndex]) === null || _logs$pagedRowIndex2 === void 0 ? void 0 : _logs$pagedRowIndex2.version;
    const ruleId = (0, _lodash.get)(runLog, 'rule_id');
    const spaceIds = runLog === null || runLog === void 0 ? void 0 : runLog.space_ids;
    if (columnId === 'num_errored_actions' && runLog && onFlyoutOpen) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": "eventLogDataGridErroredActionBadge",
        style: {
          cursor: 'pointer',
          borderRadius: euiTheme.border.radius.medium
        },
        color: "hollow",
        onClick: () => onFlyoutOpen(runLog),
        onClickAriaLabel: _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.openActionErrorsFlyout', {
          defaultMessage: 'Open action errors flyout'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 9
        }
      }, value);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 7
      }
    }, renderMessageWithActionError(columnId, actionErrors, true), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_.EventLogListCellRenderer, {
      columnId: columnId,
      value: value,
      version: version,
      dateFormat: dateFormat,
      ruleId: ruleId,
      spaceIds: spaceIds,
      useExecutionStatus: isRuleUsingExecutionStatus,
      getRuleDetailsRoute: getRuleDetailsRoute,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 11
      }
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.EventLogPaginationStatus, {
    pageIndex: pagination.pageIndex,
    pageSize: pagination.pageSize,
    totalItemCount: pagination.totalItemCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": "event log",
    "data-test-subj": "eventLogList",
    columns: columns,
    rowCount: pagination.totalItemCount,
    renderCellValue: renderCell,
    columnVisibility: columnVisibilityProps,
    sorting: sortingProps,
    pagination: paginationProps,
    gridStyle: gridStyles,
    css: selectedRowCss,
    renderCellPopover: renderCellPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 7
    }
  }));
};
exports.EventLogDataGrid = EventLogDataGrid;