"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ConnectorEventLogListTableWithApi = exports.ConnectorEventLogListTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../constants");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _with_actions_api_operations = require("../../common/components/with_actions_api_operations");
var _refine_search_prompt = require("../../common/components/refine_search_prompt");
var _actions_connectors_event_log_list_kpi = require("./actions_connectors_event_log_list_kpi");
var _event_log = require("../../common/components/event_log");
var _use_multiple_spaces = require("../../../hooks/use_multiple_spaces");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/actions_connectors_list/components/actions_connectors_event_log_list_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const getParsedDate = date => {
  if (date.includes('now')) {
    var _datemath$parse;
    return ((_datemath$parse = _datemath.default.parse(date)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.format()) || date;
  }
  return date;
};
const API_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.apiError', {
  defaultMessage: 'Failed to fetch execution history'
});
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.searchPlaceholder', {
  defaultMessage: 'Search event log message'
});
const CONNECTOR_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.connectorEventLogList.initialColumns';
const getDefaultColumns = columns => {
  const columnsWithoutLockedColumn = columns.filter(column => !_constants.CONNECTOR_LOCKED_COLUMNS.includes(column));
  return [..._constants.CONNECTOR_LOCKED_COLUMNS, ...columnsWithoutLockedColumn];
};
const ALL_SPACES_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.connectorEventLogList.showAllSpacesToggle', {
  defaultMessage: 'Show connectors from all spaces'
});
const updateButtonProps = {
  iconOnly: true,
  fill: false
};
const MAX_RESULTS = 1000;
const removeLastItemWidthToExpandToFullContainerWidth = (columns, visibleColumns) => {
  const lastVisibleColumnId = visibleColumns[visibleColumns.length - 1];
  return columns.map(col => {
    if (col.id !== lastVisibleColumnId) return col;
    const {
      initialWidth,
      ...rest
    } = col;
    return rest;
  });
};
const ConnectorEventLogListTable = props => {
  const {
    localStorageKey = CONNECTOR_EVENT_LOG_LIST_STORAGE_KEY,
    refreshToken,
    loadGlobalConnectorExecutionLogAggregations,
    initialPageSize = 10,
    hasConnectorNames = false,
    hasAllSpaceSwitch = false
  } = props;
  const {
    uiSettings,
    notifications
  } = (0, _kibana.useKibana)().services;
  const [searchText, setSearchText] = (0, _react.useState)('');
  const [search, setSearch] = (0, _react.useState)('');
  const [internalRefreshToken, setInternalRefreshToken] = (0, _react.useState)(refreshToken);
  const [showFromAllSpaces, setShowFromAllSpaces] = (0, _react.useState)(false);

  // Data grid states
  const [logs, setLogs] = (0, _react.useState)();
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(() => {
    return getDefaultColumns(_constants.GLOBAL_CONNECTOR_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS);
  });
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const [filter, setFilter] = (0, _react.useState)([]);
  const [actualTotalItemCount, setActualTotalItemCount] = (0, _react.useState)(0);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: initialPageSize,
    totalItemCount: 0
  });

  // Date related states
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dateStart, setDateStart] = (0, _react.useState)('now-24h');
  const [dateEnd, setDateEnd] = (0, _react.useState)('now');
  const [dateFormat] = (0, _react.useState)(() => uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat'));
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get;
    return (uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get('timepicker:quickRanges')) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => ({
      start: from,
      end: to,
      label: display
    }))) || [];
  });
  const {
    onShowAllSpacesChange,
    canAccessMultipleSpaces,
    namespaces
  } = (0, _use_multiple_spaces.useMultipleSpaces)({
    setShowFromAllSpaces,
    showFromAllSpaces,
    visibleColumns,
    setVisibleColumns
  });
  const isInitialized = (0, _react.useRef)(false);
  const isOnLastPage = (0, _react.useMemo)(() => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return (pageIndex + 1) * pageSize >= MAX_RESULTS;
  }, [pagination]);

  // Formats the sort columns to be consumed by the API endpoint
  const formattedSort = (0, _react.useMemo)(() => {
    return sortingColumns.map(({
      id: sortId,
      direction
    }) => ({
      [sortId]: {
        order: direction
      }
    }));
  }, [sortingColumns]);
  const loadEventLogs = async () => {
    if (!loadGlobalConnectorExecutionLogAggregations) {
      return;
    }
    setIsLoading(true);
    try {
      const result = await loadGlobalConnectorExecutionLogAggregations({
        sort: formattedSort,
        outcomeFilter: filter,
        message: searchText,
        dateStart: getParsedDate(dateStart),
        dateEnd: getParsedDate(dateEnd),
        page: pagination.pageIndex,
        perPage: pagination.pageSize,
        namespaces
      });
      setLogs(result.data);
      setPagination({
        ...pagination,
        totalItemCount: Math.min(result.total, MAX_RESULTS)
      });
      setActualTotalItemCount(result.total);
    } catch (e) {
      var _e$body$message, _e$body;
      notifications.toasts.addDanger({
        title: API_FAILED_MESSAGE,
        text: (_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : e
      });
    }
    setIsLoading(false);
  };
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex: 0,
      pageSize
    }));
  }, [setPagination]);
  const onChangePage = (0, _react.useCallback)(pageIndex => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex
    }));
  }, [setPagination]);
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (isInvalid) {
      return;
    }
    setDateStart(start);
    setDateEnd(end);
  }, [setDateStart, setDateEnd]);
  const onRefresh = () => {
    setInternalRefreshToken(Date.now());
    loadEventLogs();
  };
  const onFilterChange = (0, _react.useCallback)(newFilter => {
    setPagination(prevPagination => ({
      ...prevPagination,
      pageIndex: 0
    }));
    setFilter(newFilter);
  }, [setPagination, setFilter]);
  const onSearchChange = (0, _react.useCallback)(e => {
    if (e.target.value === '') {
      setSearchText('');
    }
    setSearch(e.target.value);
  }, [setSearchText, setSearch]);
  const onKeyUp = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      setSearchText(search);
    }
  }, [search, setSearchText]);
  const columns = (0, _react.useMemo)(() => [{
    id: 'connector_id',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.connectorId', {
      defaultMessage: 'Connector Id'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('connector_id'),
    initialWidth: 315
  }, {
    id: 'id',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.id', {
      defaultMessage: 'Execution Id'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('id'),
    initialWidth: 320
  }, {
    id: 'timestamp',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.timestamp', {
      defaultMessage: 'Timestamp'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('timestamp'),
    isResizable: false,
    actions: {
      showHide: false
    },
    initialWidth: 230
  }, {
    id: 'status',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.response', {
      defaultMessage: 'Response'
    }),
    actions: {
      showHide: false,
      showSortAsc: false,
      showSortDesc: false,
      additional: [{
        iconType: 'annotation',
        label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.showOnlyFailures', {
          defaultMessage: 'Show only failures'
        }),
        onClick: () => onFilterChange(['failure']),
        size: 'xs'
      }, {
        iconType: 'annotation',
        label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.showAll', {
          defaultMessage: 'Show all'
        }),
        onClick: () => onFilterChange([]),
        size: 'xs'
      }]
    },
    isSortable: (0, _event_log.getIsColumnSortable)('status'),
    isResizable: false,
    initialWidth: 150
  }, ...(hasConnectorNames ? [{
    id: 'connector_name',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.connectorName', {
      defaultMessage: 'Connector'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('connector_name'),
    actions: {
      showSortAsc: false,
      showSortDesc: false,
      showHide: false
    },
    initialWidth: 220
  }] : []), {
    id: 'source',
    actions: {
      showSortAsc: false,
      showSortDesc: false
    },
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.source', {
      defaultMessage: 'Source'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('source'),
    cellActions: [],
    initialWidth: 150
  }, {
    id: 'message',
    actions: {
      showSortAsc: false,
      showSortDesc: false
    },
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.message', {
      defaultMessage: 'Message'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('message'),
    cellActions: [],
    initialWidth: 600
  }, {
    id: 'execution_duration',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.duration', {
      defaultMessage: 'Duration'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('execution_duration'),
    isResizable: false,
    actions: {
      showHide: false
    },
    initialWidth: 100
  }, {
    id: 'schedule_delay',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.scheduleDelay', {
      defaultMessage: 'Schedule delay'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('schedule_delay'),
    initialWidth: 100
  }, {
    id: 'timed_out',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.timedOut', {
      defaultMessage: 'Timed out'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('timed_out'),
    initialWidth: 100
  }, ...(showFromAllSpaces ? [{
    id: 'space_ids',
    displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogList.eventLogColumn.spaceIds', {
      defaultMessage: 'Space'
    }),
    isSortable: (0, _event_log.getIsColumnSortable)('space_ids'),
    actions: {
      showSortAsc: false,
      showSortDesc: false,
      showHide: false
    },
    initialWidth: 100
  }] : [])], [onFilterChange, hasConnectorNames, showFromAllSpaces]);
  const renderList = () => {
    if (!logs) {
      return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 486,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent",
      "data-test-subj": "connectorEventLogListProgressBar",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_event_log.EventLogDataGrid, {
      columns: removeLastItemWidthToExpandToFullContainerWidth(columns, visibleColumns),
      logs: logs,
      pagination: pagination,
      sortingColumns: sortingColumns,
      visibleColumns: visibleColumns,
      dateFormat: dateFormat,
      onChangeItemsPerPage: onChangeItemsPerPage,
      onChangePage: onChangePage,
      setVisibleColumns: setVisibleColumns,
      setSortingColumns: setSortingColumns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 493,
        columnNumber: 9
      }
    }));
  };
  (0, _react.useEffect)(() => {
    loadEventLogs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sortingColumns, dateStart, dateEnd, filter, pagination.pageIndex, pagination.pageSize, searchText, showFromAllSpaces]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadEventLogs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  (0, _react.useEffect)(() => {
    localStorage.setItem(localStorageKey, JSON.stringify(visibleColumns));
  }, [localStorageKey, visibleColumns]);
  (0, _react.useEffect)(() => {
    setInternalRefreshToken(refreshToken);
  }, [refreshToken]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 540,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 541,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 542,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 543,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    isClearable: true,
    value: search,
    onChange: onSearchChange,
    onKeyUp: onKeyUp,
    placeholder: SEARCH_PLACEHOLDER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 544,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 553,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatusFilter, {
    selectedOptions: filter,
    onChange: onFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 554,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": "connectorEventLogListDatePicker",
    width: "auto",
    isLoading: isLoading,
    start: dateStart,
    end: dateEnd,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    dateFormat: dateFormat,
    commonlyUsedRanges: commonlyUsedRanges,
    updateButtonProps: updateButtonProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 13
    }
  })), hasAllSpaceSwitch && canAccessMultipleSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "showAllSpacesSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 571,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: ALL_SPACES_LABEL,
    checked: showFromAllSpaces,
    onChange: onShowAllSpacesChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 572,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_actions_connectors_event_log_list_kpi.ConnectorEventLogListKPIWithApi, {
    "data-test-subj": "connectorEventLogListKpi",
    dateStart: dateStart,
    dateEnd: dateEnd,
    outcomeFilter: filter,
    message: searchText,
    refreshToken: internalRefreshToken,
    namespaces: namespaces,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 7
    }
  }, renderList(), isOnLastPage && /*#__PURE__*/_react.default.createElement(_refine_search_prompt.RefineSearchPrompt, {
    documentSize: actualTotalItemCount,
    visibleDocumentSize: MAX_RESULTS,
    backToTopAnchor: "logs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 597,
      columnNumber: 11
    }
  })));
};
exports.ConnectorEventLogListTable = ConnectorEventLogListTable;
const ConnectorEventLogListTableWithSpaces = props => {
  const {
    spaces
  } = (0, _kibana.useKibana)().services;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const SpacesContextWrapper = (0, _react.useCallback)(spaces ? spaces.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spaces]);
  return /*#__PURE__*/_react.default.createElement(SpacesContextWrapper, {
    feature: "triggersActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ConnectorEventLogListTable, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 7
    }
  })));
};
const ConnectorEventLogListTableWithApi = exports.default = exports.ConnectorEventLogListTableWithApi = (0, _with_actions_api_operations.withActionOperations)(ConnectorEventLogListTableWithSpaces);

// eslint-disable-next-line import/no-default-export