"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorEventLogListKPIWithApi = exports.ConnectorEventLogListKPI = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _with_actions_api_operations = require("../../common/components/with_actions_api_operations");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _event_log = require("../../common/components/event_log");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/actions_connectors_list/components/actions_connectors_event_log_list_kpi.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getParsedDate = date => {
  if (date.includes('now')) {
    var _datemath$parse;
    return ((_datemath$parse = _datemath.default.parse(date)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.format()) || date;
  }
  return date;
};
const API_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogListKpi.apiError', {
  defaultMessage: 'Failed to fetch event log KPI.'
});
const RESPONSE_TOOLTIP = _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorEventLogListKpi.responseTooltip', {
  defaultMessage: 'The responses for up to 10,000 most recent actions triggered.'
});
const ConnectorEventLogListKPI = props => {
  var _kpi$success, _kpi$warning, _kpi$failure, _kpi$unknown;
  const {
    dateStart,
    dateEnd,
    outcomeFilter,
    message,
    refreshToken,
    namespaces,
    loadGlobalConnectorExecutionKPIAggregations
  } = props;
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isInitialized = (0, _react.useRef)(false);
  const isUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [kpi, setKpi] = (0, _react.useState)();
  const loadKPIFn = (0, _react.useMemo)(() => {
    return loadGlobalConnectorExecutionKPIAggregations;
  }, [loadGlobalConnectorExecutionKPIAggregations]);
  const loadKPIs = async () => {
    setIsLoading(true);
    try {
      const newKpi = await loadKPIFn({
        dateStart: getParsedDate(dateStart),
        dateEnd: getParsedDate(dateEnd),
        outcomeFilter,
        message,
        ...(namespaces ? {
          namespaces
        } : {})
      });
      setKpi(newKpi);
    } catch (e) {
      var _e$body$message, _e$body;
      toasts.addDanger({
        title: API_FAILED_MESSAGE,
        text: (_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : e
      });
    }
    setIsLoading(false);
  };
  (0, _react.useEffect)(() => {
    loadKPIs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dateStart, dateEnd, outcomeFilter, message, namespaces]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadKPIs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  const isLoadingData = (0, _react.useMemo)(() => isLoading || !kpi, [isLoading, kpi]);
  const getStatDescription = element => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, element, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogStat, {
    title: "Responses",
    tooltip: RESPONSE_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "connectorEventLogKpi-successOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "success",
      useExecutionStatus: isUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$success = kpi === null || kpi === void 0 ? void 0 : kpi.success) !== null && _kpi$success !== void 0 ? _kpi$success : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "connectorEventLogKpi-warningOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "warning",
      useExecutionStatus: isUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$warning = kpi === null || kpi === void 0 ? void 0 : kpi.warning) !== null && _kpi$warning !== void 0 ? _kpi$warning : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "connectorEventLogKpi-failureOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "failure",
      useExecutionStatus: isUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$failure = kpi === null || kpi === void 0 ? void 0 : kpi.failure) !== null && _kpi$failure !== void 0 ? _kpi$failure : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "connectorEventLogKpi-unknownOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "unknown",
      useExecutionStatus: isUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$unknown = kpi === null || kpi === void 0 ? void 0 : kpi.unknown) !== null && _kpi$unknown !== void 0 ? _kpi$unknown : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }))))));
};
exports.ConnectorEventLogListKPI = ConnectorEventLogListKPI;
const ConnectorEventLogListKPIWithApi = exports.ConnectorEventLogListKPIWithApi = (0, _with_actions_api_operations.withActionOperations)(ConnectorEventLogListKPI);