"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TestConnectorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _Option = require("fp-ts/Option");
var _pipeable = require("fp-ts/pipeable");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/test_connector_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestConnectorForm = ({
  connector,
  executeEnabled,
  executionResult,
  actionParams,
  setActionParams,
  onExecutionAction,
  isExecutingAction,
  actionTypeRegistry
}) => {
  const [actionErrors, setActionErrors] = (0, _react.useState)({});
  const [hasErrors, setHasErrors] = (0, _react.useState)(false);
  const actionTypeModel = actionTypeRegistry.get(connector.actionTypeId);
  const ParamsFieldsComponent = actionTypeModel.actionParamsFields;
  (0, _react.useEffect)(() => {
    (async () => {
      const res = (await (actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.validateParams(actionParams))).errors;
      setActionErrors({
        ...res
      });
      setHasErrors(!!Object.values(res).find(errors => errors.length > 0));
    })();
  }, [actionTypeModel, actionParams]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.createActionHeader', {
      defaultMessage: 'Create an action'
    }),
    children: ParamsFieldsComponent ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 19
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(ParamsFieldsComponent, {
      actionParams: actionParams,
      index: 0,
      errors: actionErrors,
      editAction: (field, value) => setActionParams({
        ...actionParams,
        [field]: value
      }),
      messageVariables: [],
      actionConnector: connector,
      executionMode: _types.ActionConnectorMode.Test,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.testConnectorForm.noActionParametersRequiredText",
      defaultMessage: "This Connector does not require any Action Parameter.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.runTestHeader', {
      defaultMessage: 'Run the test'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, executeEnabled ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Save your changes before testing the connector.",
      id: "xpack.triggersActionsUI.sections.testConnectorForm.executeTestDisabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: 'play',
      isLoading: isExecutingAction,
      isDisabled: !executeEnabled || hasErrors || isExecutingAction,
      "data-test-subj": "executeActionButton",
      onClick: onExecutionAction,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Run",
      id: "xpack.triggersActionsUI.sections.testConnectorForm.executeTestButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }))))
  }, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.testResultsHeader', {
      defaultMessage: 'Results'
    }),
    children: (0, _pipeable.pipe)(executionResult, (0, _Option.map)(result => (result === null || result === void 0 ? void 0 : result.status) === 'ok' ? /*#__PURE__*/_react.default.createElement(SuccessfulExecution, {
      executionResult: result,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(FailedExecussion, {
      executionResult: result,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    })), (0, _Option.getOrElse)(() => /*#__PURE__*/_react.default.createElement(AwaitingExecution, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 25
      }
    })))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    "data-test-subj": "test-connector-form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 10
    }
  });
};
exports.default = exports.TestConnectorForm = TestConnectorForm;
const AwaitingExecution = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  "data-test-subj": "executionAwaiting",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 173,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 174,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "When you run the test, the results will show up here.",
  id: "xpack.triggersActionsUI.sections.testConnectorForm.awaitingExecutionDescription",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 175,
    columnNumber: 7
  }
})));
const SuccessfulExecution = ({
  executionResult
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionSuccessfulTitle', {
    defaultMessage: 'Test was successful'
  }),
  color: "success",
  "data-test-subj": "executionSuccessfulResult",
  iconType: "check",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 189,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 200,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "Ensure the results are what you expect.",
  id: "xpack.triggersActionsUI.sections.testConnectorForm.executionSuccessfulDescription",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 201,
    columnNumber: 9
  }
}))), executionResult && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 209,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 210,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("h4", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 211,
    columnNumber: 11
  }
}, _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionResultDetails', {
  defaultMessage: 'Response'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 220,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "json",
  paddingSize: "m",
  overflowHeight: 300,
  isCopyable: true,
  "data-test-subj": "executionResultCodeBlock",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 221,
    columnNumber: 9
  }
}, JSON.stringify(executionResult, null, 2))));
const FailedExecussion = ({
  executionResult
}) => {
  var _executionResult$mess;
  const items = [{
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionFailureDescription', {
      defaultMessage: 'The following error was found:'
    }),
    description: (_executionResult$mess = executionResult === null || executionResult === void 0 ? void 0 : executionResult.message) !== null && _executionResult$mess !== void 0 ? _executionResult$mess : _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionFailureUnknownReason', {
      defaultMessage: 'Unknown reason'
    })
  }];
  if (executionResult !== null && executionResult !== void 0 && executionResult.serviceMessage) {
    items.push({
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionFailureAdditionalDetails', {
        defaultMessage: 'Details:'
      }),
      description: executionResult.serviceMessage
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.executionFailureTitle', {
      defaultMessage: 'Test failed to run'
    }),
    "data-test-subj": "executionFailureResult",
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export