"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorRulesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/alerting-plugin/common");
var _hooks = require("@kbn/alerts-ui-shared/src/common/hooks");
var _kibana = require("../../../common/lib/kibana");
var _rule_status_helpers = require("../../../common/lib/rule_status_helpers");
var _use_load_rules_query = require("../../hooks/use_load_rules_query");
var _constants = require("../../constants");
var _translations = require("../rules_list/translations");
var _no_permission_prompt = require("../../components/prompts/no_permission_prompt");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _rule_tag_badge = require("../rules_list/components/rule_tag_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/connector_rules_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorRulesList = props => {
  const {
    connector
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    application: {
      getUrlForApp
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [searchText, setSearchText] = (0, _react.useState)('');
  const [searchFilter, setSearchFilter] = (0, _react.useState)('');
  const [tagPopoverOpenId, setTagPopoverOpenId] = (0, _react.useState)(null);
  const [page, setPage] = (0, _react.useState)({
    index: 0,
    size: _constants.DEFAULT_CONNECTOR_RULES_LIST_PAGE_SIZE
  });
  const [sort, setSort] = (0, _react.useState)({
    field: 'name',
    direction: 'asc'
  });
  const {
    ruleTypesState,
    hasAnyAuthorizedRuleType,
    authorizedRuleTypes,
    authorizedToReadAnyRules,
    isSuccess: isLoadRuleTypesSuccess
  } = (0, _hooks.useGetRuleTypesPermissions)({
    http,
    toasts,
    filteredRuleTypes: []
  });
  const ruleTypeIds = authorizedRuleTypes.map(art => art.id);
  const ruleFilters = (0, _react.useMemo)(() => {
    const baseFilters = {
      searchText: searchFilter
    };
    if (connector.isPreconfigured) {
      return {
        filters: {
          ...baseFilters,
          kueryNode: (0, _esQuery.fromKueryExpression)(`alert.attributes.actions:{ actionRef: "${_common.preconfiguredConnectorActionRefPrefix}${connector.id}" }`)
        }
      };
    }
    if (connector.isSystemAction) {
      return {
        filters: {
          ...baseFilters,
          kueryNode: (0, _esQuery.fromKueryExpression)(`alert.attributes.actions:{ actionRef: "${_common.systemConnectorActionRefPrefix}${connector.id}" }`)
        }
      };
    }
    return {
      filters: baseFilters,
      hasReference: {
        type: 'action',
        id: connector.id
      }
    };
  }, [connector, searchFilter]);
  const {
    rulesState
  } = (0, _use_load_rules_query.useLoadRulesQuery)({
    ...ruleFilters,
    ruleTypeIds,
    hasDefaultRuleTypesFiltersOn: ruleTypeIds.length === 0,
    page,
    sort,
    onPage: setPage,
    enabled: isLoadRuleTypesSuccess && hasAnyAuthorizedRuleType
  });
  const showNoAuthPrompt = !ruleTypesState.isInitialLoad && !authorizedToReadAnyRules;
  const isInitialLoading = ruleTypesState.isInitialLoad || rulesState.initialLoad;
  const showSpinner = isInitialLoading && (ruleTypesState.isLoading || !showNoAuthPrompt && rulesState.isLoading);
  const isLoading = ruleTypesState.isLoading || rulesState.isLoading;
  const onSetTagPopoverOpenId = (0, _react.useCallback)(id => () => {
    setTagPopoverOpenId(id);
  }, [setTagPopoverOpenId]);
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorRulesList.columns.name', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      truncateText: false,
      width: '33%',
      render: (name, rule) => {
        var _ruleTypesState$data$;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 151,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          title: name,
          href: getUrlForApp('management', {
            path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getRuleDetailsRoute)(rule.id)}`
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 17
          }
        }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 162,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 163,
            columnNumber: 17
          }
        }, ((_ruleTypesState$data$ = ruleTypesState.data.get(rule.ruleTypeId)) === null || _ruleTypesState$data$ === void 0 ? void 0 : _ruleTypesState$data$.name) || rule.ruleTypeId)));
      }
    }, {
      field: 'tags',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorRulesList.columns.tags', {
        defaultMessage: 'Tags'
      }),
      width: '50px',
      sortable: false,
      render: (ruleTags, rule) => {
        return ruleTags.length > 0 ? /*#__PURE__*/_react.default.createElement(_rule_tag_badge.RuleTagBadge, {
          isOpen: tagPopoverOpenId === rule.id,
          tags: ruleTags,
          onClick: onSetTagPopoverOpenId(rule.id),
          onClose: onSetTagPopoverOpenId(null),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 13
          }
        }) : null;
      }
    }, {
      field: 'lastRun.outcome',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorRulesList.columns.lastResponse', {
        defaultMessage: 'Last response'
      }),
      width: '150px',
      sortable: true,
      truncateText: false,
      align: 'right',
      render: (_, rule) => {
        return rule.lastRun && /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: (0, _rule_status_helpers.getRuleHealthColor)(rule, euiTheme) || 'default',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 15
          }
        }, _translations.rulesLastRunOutcomeTranslationMapping[rule.lastRun.outcome]);
      }
    }];
  }, [ruleTypesState, tagPopoverOpenId, getUrlForApp, onSetTagPopoverOpenId, euiTheme]);
  const onChange = (0, _react.useCallback)(e => {
    setSearchText(e.target.value);
  }, []);
  const onSearch = (0, _react.useCallback)(() => {
    setSearchFilter(searchText);
  }, [searchText]);
  if (showNoAuthPrompt) {
    return /*#__PURE__*/_react.default.createElement(_no_permission_prompt.NoPermissionPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 12
      }
    });
  }
  if (showSpinner) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "connectorRulesListSearch",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorRulesList.fieldSearch.label', {
      defaultMessage: 'Search rules by name and tags'
    }),
    fullWidth: true,
    incremental: false,
    onChange: onChange,
    onSearch: onSearch,
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorRulesList.fieldSearch.placeholder', {
      defaultMessage: 'Search rules by name and tags'
    }),
    value: searchText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "connectorRulesList",
    loading: isLoading,
    items: rulesState.data,
    columns: columns,
    sorting: {
      sort
    },
    pagination: {
      pageIndex: page.index,
      pageSize: page.size,
      totalItemCount: ruleTypesState.isInitialLoad ? 0 : rulesState.totalItemCount
    },
    onChange: ({
      page: changedPage,
      sort: changedSort
    }) => {
      if (changedPage) {
        setPage(changedPage);
      }
      if (changedSort) {
        setSort(changedSort);
      }
    },
    rowProps: {
      'data-test-subj': 'connectorRuleRow'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  })));
};
exports.ConnectorRulesList = ConnectorRulesList;