"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _section_loading = require("../../components/section_loading");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _connector_form_fields_global = require("./connector_form_fields_global");
var _connector_overrides = require("./connector_overrides");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/connector_form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorFormFieldsComponent = ({
  actionTypeModel,
  isEdit,
  registerPreSubmitValidator
}) => {
  var _actionTypeModel$acti;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const FieldsComponent = (_actionTypeModel$acti = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.actionConnectorFields) !== null && _actionTypeModel$acti !== void 0 ? _actionTypeModel$acti : null;
  const overrides = (0, _react.useMemo)(() => {
    if (actionTypeModel) {
      return (0, _connector_overrides.connectorOverrides)(actionTypeModel.id);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.id]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_form_fields_global.ConnectorFormFieldsGlobal, {
    canSave: canSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), FieldsComponent !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, overrides !== null && overrides !== void 0 && overrides.shouldHideConnectorSettingsTitle ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "connector-settings-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorForm.connectorSettingsLabel",
    defaultMessage: "Connector settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionConnectorForm.loadingConnectorSettingsDescription",
      defaultMessage: "Loading connector settings\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FieldsComponent, {
    readOnly: !canSave,
    isEdit: isEdit,
    registerPreSubmitValidator: registerPreSubmitValidator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  })))) : null);
};
const ConnectorFormFields = exports.ConnectorFormFields = /*#__PURE__*/(0, _react.memo)(ConnectorFormFieldsComponent);