"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _check_action_type_enabled = require("@kbn/alerts-ui-shared/src/check_action_type_enabled");
var _translations = require("../translations");
var _action_connector_api = require("../../lib/action_connector_api");
var _action_type_compare = require("../../lib/action_type_compare");
var _kibana = require("../../../common/lib/kibana");
var _section_loading = require("../../components/section_loading");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/action_type_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filterActionTypes = (actionTypes, searchValue) => {
  if ((0, _lodash.isEmpty)(searchValue)) {
    return actionTypes;
  }
  return actionTypes.filter(actionType => {
    var _actionType$actionTyp;
    const searchTargets = [actionType.name, actionType.selectMessage, (_actionType$actionTyp = actionType.actionType) === null || _actionType$actionTyp === void 0 ? void 0 : _actionType$actionTyp.name].filter(Boolean).map(text => text.toLowerCase());
    const searchValueLowerCase = searchValue.toLowerCase();
    return searchTargets.some(searchTarget => searchTarget.includes(searchValueLowerCase));
  });
};
const ActionTypeMenu = ({
  onActionTypeChange,
  featureId,
  setHasActionsUpgradeableByTrial,
  setAllActionTypes,
  actionTypeRegistry,
  searchValue = ''
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [loadingActionTypes, setLoadingActionTypes] = (0, _react.useState)(false);
  const [actionTypesIndex, setActionTypesIndex] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setLoadingActionTypes(true);
        const availableActionTypes = await (0, _action_connector_api.loadActionTypes)({
          http,
          featureId
        });
        setLoadingActionTypes(false);
        const index = {};
        for (const actionTypeItem of availableActionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setActionTypesIndex(index);
        if (setAllActionTypes) {
          setAllActionTypes(index);
        }
        // determine if there are actions disabled by license that that
        // would be enabled by upgrading to gold or trial
        if (setHasActionsUpgradeableByTrial) {
          const hasActionsUpgradeableByTrial = availableActionTypes.some(action => !index[action.id].enabledInLicense && index[action.id].minimumLicenseRequired === 'gold');
          setHasActionsUpgradeableByTrial(hasActionsUpgradeableByTrial);
        }
      } catch (e) {
        if (toasts) {
          toasts.addDanger({
            title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
              defaultMessage: 'Unable to load connector types'
            })
          });
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const registeredActionTypes = Object.entries(actionTypesIndex !== null && actionTypesIndex !== void 0 ? actionTypesIndex : []).filter(([id, details]) => {
    var _actionTypeModel$getH;
    const actionTypeModel = actionTypeRegistry.has(id) ? actionTypeRegistry.get(id) : undefined;
    const shouldHideInUi = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : (_actionTypeModel$getH = actionTypeModel.getHideInUi) === null || _actionTypeModel$getH === void 0 ? void 0 : _actionTypeModel$getH.call(actionTypeModel, actionTypesIndex ? Object.values(actionTypesIndex) : []);
    return details.enabledInConfig === true && !shouldHideInUi;
  }).map(([id, actionType]) => {
    const actionTypeModel = actionTypeRegistry.get(id);
    return {
      iconClass: actionTypeModel ? actionTypeModel.iconClass : '',
      selectMessage: actionTypeModel ? actionTypeModel.selectMessage : '',
      actionType,
      name: actionType.name,
      isExperimental: actionTypeModel.isExperimental
    };
  });
  const filteredConnectors = (0, _react.useMemo)(() => filterActionTypes(registeredActionTypes, searchValue), [registeredActionTypes, searchValue]);
  const cardNodes = filteredConnectors.sort((a, b) => (0, _action_type_compare.actionTypeCompare)(a.actionType, b.actionType)).map((item, index) => {
    const checkEnabledResult = (0, _check_action_type_enabled.checkActionTypeEnabled)(item.actionType);
    const card = /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      betaBadgeProps: item.isExperimental ? {
        label: _translations.TECH_PREVIEW_LABEL,
        tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION
      } : undefined,
      role: "listitem",
      titleSize: "xs",
      "data-test-subj": `${item.actionType.id}-card`,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "xl",
        type: item.iconClass,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 17
        }
      }),
      title: item.name,
      description: item.selectMessage,
      isDisabled: !checkEnabledResult.isEnabled,
      onClick: () => {
        onActionTypeChange(item.actionType);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }, checkEnabledResult.isEnabled && card, checkEnabledResult.isEnabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: checkEnabledResult.message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, card));
  });
  return loadingActionTypes ? /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.loadingConnectorTypesDescription",
    defaultMessage: "Loading connector types\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement("div", {
    className: "actConnectorsListGrid",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "xl",
    columns: 3,
    role: "list",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListLabel', {
      defaultMessage: 'Available connector types'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, cardNodes));
};
exports.ActionTypeMenu = ActionTypeMenu;