"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _parse_duration = require("@kbn/alerting-plugin/common/parse_duration");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _hooks = require("@kbn/alerts-ui-shared/src/common/hooks");
var _translations = require("../translations");
var _get_experimental_features = require("../../../common/get_experimental_features");
var _types = require("../../../types");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _connectors_selection = require("./connectors_selection");
var _validate_params_for_warnings = require("../../lib/validate_params_for_warnings");
var _value_validators = require("../../lib/value_validators");
var _use_rule_alert_fields = require("../../hooks/use_rule_alert_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/action_type_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const preconfiguredMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.preconfiguredTitleMessage', {
  defaultMessage: '(preconfigured)'
});
const ActionTypeForm = ({
  actionItem,
  actionConnector,
  index,
  onAddConnector,
  onConnectorSelected,
  onDeleteAction,
  setActionUseAlertDataForTemplate,
  setActionParamsProperty,
  setActionFrequencyProperty,
  setActionAlertsFilterProperty,
  actionTypesIndex,
  connectors,
  defaultActionGroupId,
  defaultActionMessage,
  messageVariables,
  summaryMessageVariables,
  actionGroups,
  setActionGroupIdByIndex,
  actionTypeRegistry,
  isActionGroupDisabledForActionType,
  recoveryActionGroup,
  hideNotifyWhen = false,
  defaultSummaryMessage,
  hasAlertsMappings,
  minimumThrottleInterval,
  notifyWhenSelectOptions,
  producerId,
  featureId,
  ruleTypeId,
  disableErrorMessages
}) => {
  var _actionGroups$find, _actionItem$frequency, _actionItem$frequency2, _actionItem$frequency3, _actionItem$frequency4, _actionItem$useAlertD, _actionItem$frequency5, _actionTypeRegistered, _actionItem$frequency6, _selectedActionGroup$, _actionItem$frequency7, _actionItem$frequency8;
  const {
    application: {
      capabilities
    },
    settings,
    http,
    notifications,
    unifiedSearch,
    data
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isOpen, setIsOpen] = (0, _react.useState)(true);
  const [availableActionVariables, setAvailableActionVariables] = (0, _react.useState)([]);
  const defaultActionGroup = actionGroups === null || actionGroups === void 0 ? void 0 : actionGroups.find(({
    id
  }) => id === defaultActionGroupId);
  const selectedActionGroup = (_actionGroups$find = actionGroups === null || actionGroups === void 0 ? void 0 : actionGroups.find(({
    id
  }) => id === actionItem.group)) !== null && _actionGroups$find !== void 0 ? _actionGroups$find : defaultActionGroup;
  const [actionGroup, setActionGroup] = (0, _react.useState)();
  const [actionParamsErrors, setActionParamsErrors] = (0, _react.useState)({
    errors: {}
  });
  const [actionThrottle, setActionThrottle] = (0, _react.useState)((_actionItem$frequency = actionItem.frequency) !== null && _actionItem$frequency !== void 0 && _actionItem$frequency.throttle ? (0, _parse_duration.getDurationNumberInItsUnit)(actionItem.frequency.throttle) : null);
  const [actionThrottleUnit, setActionThrottleUnit] = (0, _react.useState)((_actionItem$frequency2 = actionItem.frequency) !== null && _actionItem$frequency2 !== void 0 && _actionItem$frequency2.throttle ? (0, _parse_duration.getDurationUnitValue)((_actionItem$frequency3 = actionItem.frequency) === null || _actionItem$frequency3 === void 0 ? void 0 : _actionItem$frequency3.throttle) : 'h');
  const [minimumActionThrottle = -1, minimumActionThrottleUnit] = minimumThrottleInterval !== null && minimumThrottleInterval !== void 0 ? minimumThrottleInterval : [-1, 's'];
  const [warning, setWarning] = (0, _react.useState)(null);
  const [useDefaultMessage, setUseDefaultMessage] = (0, _react.useState)(false);
  const isSummaryAction = (_actionItem$frequency4 = actionItem.frequency) === null || _actionItem$frequency4 === void 0 ? void 0 : _actionItem$frequency4.summary;
  const [useAlertTemplateFields, setUseAlertTemplateFields] = (0, _react.useState)((_actionItem$useAlertD = actionItem === null || actionItem === void 0 ? void 0 : actionItem.useAlertDataForTemplate) !== null && _actionItem$useAlertD !== void 0 ? _actionItem$useAlertD : false);
  const [storedActionParamsForAlertFieldsToggle, setStoredActionParamsForAlertFieldsToggle] = (0, _react.useState)({});
  const {
    fields: alertFields
  } = (0, _use_rule_alert_fields.useRuleTypeAlertFields)(http, ruleTypeId, useAlertTemplateFields);
  const {
    ruleTypesState
  } = (0, _hooks.useGetRuleTypesPermissions)({
    http,
    toasts: notifications.toasts,
    filteredRuleTypes: []
  });
  const templateFields = (0, _react.useMemo)(() => useAlertTemplateFields ? alertFields : availableActionVariables, [alertFields, availableActionVariables, useAlertTemplateFields]);
  const actAccordionActionFormCss = (0, _react2.css)`
    .actAccordionActionForm {
      background-color: ${euiTheme.colors.lightestShade};

      .euiCard {
        box-shador: none;
      }
      .actAccordionActionForm__button {
        padding: ${euiTheme.size.m};
        padding-left: ${euiTheme.size.l};
      }

      .euiAccordion__arrow {
        transform: translateX(${euiTheme.size.m}) rotate(0deg) !important;
      }

      .euiAccordion__arrow[aria-expanded='true'] {
        transform: translateX(${euiTheme.size.m}) rotate(90deg) !important;
      }
    }
  `;
  let showMustacheAutocompleteSwitch;
  try {
    showMustacheAutocompleteSwitch = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('showMustacheAutocompleteSwitch') && ruleTypeId;
  } catch (e) {
    showMustacheAutocompleteSwitch = false;
  }
  const handleUseAlertTemplateFields = (0, _react.useCallback)(() => {
    setUseAlertTemplateFields(prevVal => {
      if (setActionUseAlertDataForTemplate) {
        setActionUseAlertDataForTemplate(!prevVal, index);
      }
      return !prevVal;
    });
    const currentActionParams = {
      ...actionItem.params
    };
    for (const key of Object.keys(currentActionParams)) {
      var _storedActionParamsFo;
      setActionParamsProperty(key, (_storedActionParamsFo = storedActionParamsForAlertFieldsToggle[key]) !== null && _storedActionParamsFo !== void 0 ? _storedActionParamsFo : '', index);
    }
    setStoredActionParamsForAlertFieldsToggle(currentActionParams);
  }, [setActionUseAlertDataForTemplate, storedActionParamsForAlertFieldsToggle, setStoredActionParamsForAlertFieldsToggle, setActionParamsProperty, actionItem.params, index]);
  const getDefaultParams = async () => {
    const connectorType = await actionTypeRegistry.get(actionItem.actionTypeId);
    let defaultParams;
    if (actionItem.group === recoveryActionGroup) {
      defaultParams = connectorType.defaultRecoveredActionParams;
    }
    if (!defaultParams) {
      defaultParams = connectorType.defaultActionParams;
    }
    return defaultParams;
  };
  const [showMinimumThrottleWarning, showMinimumThrottleUnitWarning] = (0, _react.useMemo)(() => {
    try {
      if (!actionThrottle) return [false, false];
      const throttleUnitDuration = (0, _parse_duration.parseDuration)(`1${actionThrottleUnit}`);
      const minThrottleUnitDuration = (0, _parse_duration.parseDuration)(`1${minimumActionThrottleUnit}`);
      const boundedThrottle = throttleUnitDuration > minThrottleUnitDuration ? actionThrottle : Math.max(actionThrottle, minimumActionThrottle);
      const boundedThrottleUnit = (0, _parse_duration.parseDuration)(`${actionThrottle}${actionThrottleUnit}`) >= minThrottleUnitDuration ? actionThrottleUnit : minimumActionThrottleUnit;
      return [boundedThrottle !== actionThrottle, boundedThrottleUnit !== actionThrottleUnit];
    } catch (e) {
      return [false, false];
    }
  }, [minimumActionThrottle, minimumActionThrottleUnit, actionThrottle, actionThrottleUnit]);
  (0, _react.useEffect)(() => {
    (async () => {
      setAvailableActionVariables(messageVariables ? getAvailableActionVariables(messageVariables, summaryMessageVariables, selectedActionGroup, isSummaryAction) : []);
      const defaultParams = await getDefaultParams();
      if (defaultParams) {
        for (const [key, paramValue] of Object.entries(defaultParams)) {
          const defaultAADParams = {};
          if (actionItem.params[key] === undefined || actionItem.params[key] === null) {
            setActionParamsProperty(key, paramValue, index);
            // Add default param to AAD defaults only if it does not contain any template code
            if (typeof paramValue !== 'string' || !paramValue.match(/{{.*?}}/g)) {
              defaultAADParams[key] = paramValue;
            }
          }
          setStoredActionParamsForAlertFieldsToggle(defaultAADParams);
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem.group, (_actionItem$frequency5 = actionItem.frequency) === null || _actionItem$frequency5 === void 0 ? void 0 : _actionItem$frequency5.summary]);
  (0, _react.useEffect)(() => {
    (async () => {
      const defaultParams = await getDefaultParams();
      if (defaultParams && actionGroup) {
        const defaultAADParams = {};
        for (const [key, paramValue] of Object.entries(defaultParams)) {
          setActionParamsProperty(key, paramValue, index);
          if (!paramValue.match(/{{.*?}}/g)) {
            defaultAADParams[key] = paramValue;
          }
        }
        setStoredActionParamsForAlertFieldsToggle(defaultAADParams);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionGroup]);
  (0, _react.useEffect)(() => {
    (async _actionTypeRegistry$g => {
      if (disableErrorMessages) {
        setActionParamsErrors({
          errors: {}
        });
        return;
      }
      const res = await ((_actionTypeRegistry$g = actionTypeRegistry.get(actionItem.actionTypeId)) === null || _actionTypeRegistry$g === void 0 ? void 0 : _actionTypeRegistry$g.validateParams(actionItem.params));
      setActionParamsErrors(res);
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem, disableErrorMessages]);
  const [queryError, setQueryError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (async () => {
      if (disableErrorMessages) {
        setQueryError(null);
        return;
      }
      setQueryError((0, _value_validators.validateActionFilterQuery)(actionItem));
    })();
  }, [actionItem, disableErrorMessages]);
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isEmpty)(storedActionParamsForAlertFieldsToggle) && actionItem.params.subAction) {
      setStoredActionParamsForAlertFieldsToggle(actionItem.params);
    }
  }, [actionItem.params, storedActionParamsForAlertFieldsToggle]);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const actionGroupDisplay = (actionGroupId, actionGroupName, actionTypeId) => isActionGroupDisabledForActionType ? isActionGroupDisabledForActionType(actionGroupId, actionTypeId) ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.addNewActionConnectorActionGroup.display', {
    defaultMessage: '{actionGroupName} (Not Currently Supported)',
    values: {
      actionGroupName
    }
  }) : actionGroupName : actionGroupName;
  const isActionGroupDisabled = (actionGroupId, actionTypeId) => isActionGroupDisabledForActionType ? isActionGroupDisabledForActionType(actionGroupId, actionTypeId) : false;
  const onActionFrequencyChange = frequency => {
    const {
      notifyWhen,
      throttle,
      summary
    } = frequency || {};
    setActionFrequencyProperty('notifyWhen', notifyWhen, index);
    if (throttle) {
      setActionThrottle((0, _parse_duration.getDurationNumberInItsUnit)(throttle));
      setActionThrottleUnit((0, _parse_duration.getDurationUnitValue)(throttle));
    }
    setActionFrequencyProperty('throttle', throttle ? throttle : null, index);
    setActionFrequencyProperty('summary', summary, index);
  };
  const actionNotifyWhen = /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleActionsNotifyWhen, {
    frequency: actionItem.frequency,
    throttle: actionThrottle,
    throttleUnit: actionThrottleUnit,
    hasAlertsMappings: hasAlertsMappings,
    onChange: onActionFrequencyChange,
    showMinimumThrottleWarning: showMinimumThrottleWarning,
    showMinimumThrottleUnitWarning: showMinimumThrottleUnitWarning,
    notifyWhenSelectOptions: notifyWhenSelectOptions,
    onUseDefaultMessage: () => setUseDefaultMessage(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 5
    }
  });
  const actionTypeRegistered = actionTypeRegistry.get(actionConnector.actionTypeId);
  if (!actionTypeRegistered) return null;
  const allowGroupConnector = ((_actionTypeRegistered = actionTypeRegistered === null || actionTypeRegistered === void 0 ? void 0 : actionTypeRegistered.subtype) !== null && _actionTypeRegistered !== void 0 ? _actionTypeRegistered : []).map(atr => atr.id);
  const showActionGroupErrorIcon = () => {
    return !isOpen && (0, _lodash.some)(actionParamsErrors.errors, error => !(0, _lodash.isEmpty)(error));
  };
  const ParamsFieldsComponent = actionTypeRegistered.actionParamsFields;
  const checkEnabledResult = (0, _alertsUiShared.checkActionFormActionTypeEnabled)(actionTypesIndex[actionConnector.actionTypeId], connectors.filter(connector => connector.isPreconfigured));
  const showSelectActionGroup = actionGroups && selectedActionGroup && setActionGroupIdByIndex && !((_actionItem$frequency6 = actionItem.frequency) !== null && _actionItem$frequency6 !== void 0 && _actionItem$frequency6.summary);
  const ruleType = ruleTypeId ? ruleTypesState.data.get(ruleTypeId) : null;
  const showActionAlertsFilter = (ruleType === null || ruleType === void 0 ? void 0 : ruleType.hasAlertsMappings) || producerId === _ruleDataUtils.AlertConsumers.SIEM;
  const accordionContent = checkEnabledResult.isEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    style: {
      borderBottom: `1px solid ${euiTheme.colors.lightShade}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionTypeForm.actionIdLabel",
      defaultMessage: "{connectorInstance} connector",
      values: {
        connectorInstance: actionTypesIndex ? actionTypesIndex[actionConnector.actionTypeId].name : actionConnector.actionTypeId
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 13
      }
    }),
    labelAppend: canSave && actionTypesIndex && actionTypesIndex[actionConnector.actionTypeId].enabledInConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": `addNewActionConnectorButton-${actionItem.actionTypeId}`,
      onClick: onAddConnector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 473,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Add connector",
      id: "xpack.triggersActionsUI.sections.actionTypeForm.addNewConnectorEmptyButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 478,
        columnNumber: 17
      }
    })) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_connectors_selection.ConnectorsSelection, {
    allowGroupConnector: allowGroupConnector,
    actionItem: actionItem,
    accordionIndex: index,
    actionTypesIndex: actionTypesIndex,
    actionTypeRegistered: actionTypeRegistered,
    connectors: connectors,
    onConnectorSelected: onConnectorSelected,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 9
    }
  }), !hideNotifyWhen && actionNotifyWhen, showSelectActionGroup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideNotifyWhen && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 500,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      htmlFor: `addNewActionConnectorActionGroup-${actionItem.actionTypeId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 503,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionTypeForm.actionRunWhenInActionGroup",
      defaultMessage: "Run when",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 506,
        columnNumber: 19
      }
    })),
    fullWidth: true,
    id: `addNewActionConnectorActionGroup-${actionItem.actionTypeId}`,
    "data-test-subj": `addNewActionConnectorActionGroup-${index}`,
    options: actionGroups.map(({
      id: value,
      name
    }) => ({
      value,
      inputDisplay: actionGroupDisplay(value, name, actionItem.actionTypeId),
      disabled: isActionGroupDisabled(value, actionItem.actionTypeId),
      'data-test-subj': `addNewActionConnectorActionGroup-${index}-option-${value}`
    })),
    valueOfSelected: selectedActionGroup.id,
    onChange: group => {
      setActionGroupIdByIndex(group, index);
      setActionGroup(group);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 501,
      columnNumber: 13
    }
  })), showActionAlertsFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideNotifyWhen && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 531,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: queryError,
    isInvalid: !!queryError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 532,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleActionsAlertsFilter, {
    action: actionItem,
    onChange: query => setActionAlertsFilterProperty('query', query, index),
    appName: featureId,
    ruleTypeId: ruleTypeId,
    plugins: {
      http,
      unifiedSearch,
      data,
      notifications
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 533,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 546,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleActionsAlertsFilterTimeframe, {
    action: actionItem,
    settings: settings,
    onChange: timeframe => setActionAlertsFilterProperty('timeframe', timeframe, index),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 555,
      columnNumber: 7
    }
  }, ParamsFieldsComponent ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 13
    }
  }, showMustacheAutocompleteSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 560,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: "Use template fields from alerts index",
    checked: useAlertTemplateFields,
    onChange: handleUseAlertTemplateFields,
    "data-test-subj": "mustacheAutocompleteSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 561,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 569,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 570,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(ParamsFieldsComponent, {
    actionParams: actionItem.params,
    errors: actionParamsErrors.errors,
    index: index,
    selectedActionGroupId: selectedActionGroup === null || selectedActionGroup === void 0 ? void 0 : selectedActionGroup.id,
    editAction: (key, value, i) => {
      setWarning((0, _validate_params_for_warnings.validateParamsForWarnings)(value, http.basePath.publicBaseUrl, availableActionVariables));
      setActionParamsProperty(key, value, i);
    },
    messageVariables: templateFields,
    defaultMessage:
    // if action is a summary action, show the default summary message
    isSummaryAction ? defaultSummaryMessage : (_selectedActionGroup$ = selectedActionGroup === null || selectedActionGroup === void 0 ? void 0 : selectedActionGroup.defaultActionMessage) !== null && _selectedActionGroup$ !== void 0 ? _selectedActionGroup$ : defaultActionMessage,
    useDefaultMessage: useDefaultMessage,
    actionConnector: actionConnector,
    executionMode: _types.ActionConnectorMode.ActionForm,
    ruleTypeId: ruleTypeId,
    producerId: producerId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 571,
      columnNumber: 19
    }
  }), warning ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 601,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: warning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 602,
      columnNumber: 23
    }
  })) : null)))) : null)) : checkEnabledResult.messageCard;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: isOpen,
    css: actAccordionActionFormCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    key: index,
    id: index.toString(),
    onToggle: setIsOpen,
    paddingSize: "none",
    className: "actAccordionActionForm",
    buttonContentClassName: "actAccordionActionForm__button",
    "data-test-subj": `alertActionAccordion-${index}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 629,
        columnNumber: 13
      }
    }, showActionGroupErrorIcon() ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 631,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionErrorToolTip', {
        defaultMessage: 'Action contains errors.'
      }),
      type: "warning",
      color: "danger",
      size: "m",
      iconProps: {
        'data-test-subj': 'action-group-error-icon'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 632,
        columnNumber: 19
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 646,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: actionTypeRegistered.iconClass,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 647,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 650,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 651,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 652,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 653,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 654,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "{actionConnectorName}",
      id: "xpack.triggersActionsUI.sections.actionTypeForm.existingAlertActionTypeEditTitle",
      values: {
        actionConnectorName: `${actionConnector.name} ${actionConnector.isPreconfigured ? preconfiguredMessage : ''}`
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 655,
        columnNumber: 25
      }
    })), (selectedActionGroup || ((_actionItem$frequency7 = actionItem.frequency) === null || _actionItem$frequency7 === void 0 ? void 0 : _actionItem$frequency7.summary)) && !isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 666,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "clock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 667,
        columnNumber: 27
      }
    }, (_actionItem$frequency8 = actionItem.frequency) !== null && _actionItem$frequency8 !== void 0 && _actionItem$frequency8.summary ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.summaryGroupTitle', {
      defaultMessage: 'Summary of alerts'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.runWhenGroupTitle', {
      defaultMessage: 'Run when {groupName}',
      values: {
        groupName: selectedActionGroup.name.toLocaleLowerCase()
      }
    }))), warning && !isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 688,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "warning-badge",
      iconType: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 689,
        columnNumber: 27
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionWarningsTitle', {
      defaultMessage: '1 warning'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 703,
        columnNumber: 23
      }
    }, checkEnabledResult.isEnabled === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "danger",
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionDisabledTitle', {
        defaultMessage: 'This action is disabled'
      }),
      position: "right",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 706,
        columnNumber: 29
      }
    }))))))), actionTypeRegistered && actionTypeRegistered.isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 725,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      "data-test-subj": "action-type-form-beta-badge",
      label: _translations.TECH_PREVIEW_LABEL,
      tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 726,
        columnNumber: 19
      }
    }))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "danger",
      className: "actAccordionActionForm__extraAction",
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.accordion.deleteIconAriaLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: onDeleteAction,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 736,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 9
    }
  }, accordionContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 753,
      columnNumber: 7
    }
  }));
};
exports.ActionTypeForm = ActionTypeForm;
function getAvailableActionVariables(actionVariables, summaryActionVariables, actionGroup, isSummaryAction) {
  const transformedActionVariables = (0, _alertsUiShared.transformActionVariables)(actionVariables, summaryActionVariables, actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.omitMessageVariables, isSummaryAction);

  // partition deprecated items so they show up last
  const partitionedActionVariables = (0, _lodash.partition)(transformedActionVariables, v => v.deprecated !== true);
  return partitionedActionVariables.reduce((acc, curr) => {
    return [...acc, ...curr.sort((a, b) => a.name.toUpperCase().localeCompare(b.name.toUpperCase()))];
  }, []);
}