"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ActionForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _check_action_type_enabled = require("@kbn/alerts-ui-shared/src/check_action_type_enabled");
var _translations = require("../translations");
var _action_connector_api = require("../../lib/action_connector_api");
var _section_loading = require("../../components/section_loading");
var _action_type_form = require("./action_type_form");
var _connector_add_inline = require("./connector_add_inline");
var _action_type_compare = require("../../lib/action_type_compare");
var _constants = require("../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _ = require(".");
var _suspended_component_with_props = require("../../lib/suspended_component_with_props");
var _system_action_type_form = require("./system_action_type_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/action_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionForm = ({
  actions,
  defaultActionGroupId,
  setActionIdByIndex,
  setActionGroupIdByIndex,
  setActionUseAlertDataForTemplate,
  setActions,
  setActionParamsProperty,
  setActionFrequencyProperty,
  setActionAlertsFilterProperty,
  featureId,
  messageVariables,
  summaryMessageVariables,
  actionGroups,
  defaultActionMessage,
  setHasActionsDisabled,
  setHasActionsWithBrokenConnector,
  actionTypeRegistry,
  recoveryActionGroup,
  isActionGroupDisabledForActionType,
  hideActionHeader,
  hideNotifyWhen,
  defaultSummaryMessage,
  hasAlertsMappings,
  minimumThrottleInterval,
  notifyWhenSelectOptions,
  defaultRuleFrequency = _constants.DEFAULT_FREQUENCY,
  ruleTypeId,
  producerId,
  disableErrorMessages
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [addModalVisible, setAddModalVisibility] = (0, _react.useState)(false);
  const [activeActionItem, setActiveActionItem] = (0, _react.useState)(undefined);
  const [isAddActionPanelOpen, setIsAddActionPanelOpen] = (0, _react.useState)(true);
  const [connectors, setConnectors] = (0, _react.useState)([]);
  const [isLoadingConnectors, setIsLoadingConnectors] = (0, _react.useState)(false);
  const [isLoadingActionTypes, setIsLoadingActionTypes] = (0, _react.useState)(false);
  const [actionTypesIndex, setActionTypesIndex] = (0, _react.useState)(undefined);
  const [emptyActionsIds, setEmptyActionsIds] = (0, _react.useState)([]);
  const closeAddConnectorModal = (0, _react.useCallback)(() => setAddModalVisibility(false), [setAddModalVisibility]);

  // load action types
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setIsLoadingActionTypes(true);
        const registeredActionTypes = (await (0, _action_connector_api.loadActionTypes)({
          http,
          featureId,
          includeSystemActions: true
        })).sort((a, b) => a.name.localeCompare(b.name));
        const index = {};
        for (const actionTypeItem of registeredActionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setActionTypesIndex(index);
      } catch (e) {
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.unableToLoadConnectorTypesMessage', {
            defaultMessage: 'Unable to load connector types'
          })
        });
      } finally {
        setIsLoadingActionTypes(false);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // load connectors
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setIsLoadingConnectors(true);
        const loadedConnectors = await (0, _action_connector_api.loadAllActions)({
          http,
          includeSystemActions: true
        });
        setConnectors(loadedConnectors.filter(connector => !connector.isMissingSecrets || connector.isSystemAction));
      } catch (e) {
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.unableToLoadActionsMessage', {
            defaultMessage: 'Unable to load connectors'
          })
        });
      } finally {
        setIsLoadingConnectors(false);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    const setActionTypesAvalilability = () => {
      const preconfiguredConnectors = connectors.filter(connector => connector.isPreconfigured);
      const hasActionsDisabled = actions.some(action => actionTypesIndex && !actionTypesIndex[action.actionTypeId].enabled && !(0, _check_action_type_enabled.checkActionFormActionTypeEnabled)(actionTypesIndex[action.actionTypeId], preconfiguredConnectors).isEnabled);
      if (setHasActionsDisabled) {
        setHasActionsDisabled(hasActionsDisabled);
      }
    };
    if (connectors.length > 0 && actionTypesIndex) {
      setActionTypesAvalilability();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectors, actionTypesIndex]);
  (0, _react.useEffect)(() => {
    const hasActionWithBrokenConnector = actions.some(action => !connectors.find(connector => connector.id === action.id));
    if (setHasActionsWithBrokenConnector) {
      setHasActionsWithBrokenConnector(hasActionWithBrokenConnector);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actions, connectors]);
  function addActionType(actionTypeModel) {
    var _actionTypeModel$subt, _actionTypesIndex$act;
    if (!defaultActionGroupId) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.unableToAddAction', {
          defaultMessage: 'Unable to add action, because default action group is not defined'
        })
      });
      return;
    }
    setIsAddActionPanelOpen(false);
    const allowGroupConnector = ((_actionTypeModel$subt = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subtype) !== null && _actionTypeModel$subt !== void 0 ? _actionTypeModel$subt : []).map(atm => atm.id);
    const isSystemActionType = Boolean(actionTypesIndex && ((_actionTypesIndex$act = actionTypesIndex[actionTypeModel.id]) === null || _actionTypesIndex$act === void 0 ? void 0 : _actionTypesIndex$act.isSystemActionType));
    let actionTypeConnectors = connectors.filter(field => field.actionTypeId === actionTypeModel.id);
    const actionToPush = isSystemActionType ? {
      id: '',
      actionTypeId: actionTypeModel.id,
      params: {},
      uuid: (0, _uuid.v4)()
    } : {
      id: '',
      actionTypeId: actionTypeModel.id,
      group: defaultActionGroupId,
      params: {},
      frequency: defaultRuleFrequency,
      uuid: (0, _uuid.v4)()
    };
    if (actionTypeConnectors.length === 0) {
      actionTypeConnectors = connectors.filter(field => allowGroupConnector.includes(field.actionTypeId));
      if (actionTypeConnectors.length > 0) {
        // If a connector was successfully found, update the actionTypeId
        actions.push({
          ...actionToPush,
          actionTypeId: actionTypeConnectors[0].actionTypeId
        });
        setActionIdByIndex(actionTypeConnectors[0].id, actions.length - 1);
      } else {
        // if no connectors exists or all connectors is already assigned an action under current alert
        // set actionType as id to be able to create new connector within the alert form
        actions.push(actionToPush);
        setActionIdByIndex(actions.length.toString(), actions.length - 1);
        setEmptyActionsIds([...emptyActionsIds, actions.length.toString()]);
      }
    } else {
      actions.push(actionToPush);
      setActionIdByIndex(actionTypeConnectors[0].id, actions.length - 1);
    }
  }
  let actionTypeNodes = null;
  let hasDisabledByLicenseActionTypes = false;
  if (actionTypesIndex) {
    const preconfiguredConnectors = connectors.filter(connector => connector.isPreconfigured);
    actionTypeNodes = actionTypeRegistry.list().filter(item => {
      var _item$getHideInUi;
      return actionTypesIndex[item.id] && !((_item$getHideInUi = item.getHideInUi) !== null && _item$getHideInUi !== void 0 && _item$getHideInUi.call(item, Object.values(actionTypesIndex)));
    }).filter(item => !!item.actionParamsFields).sort((a, b) => (0, _action_type_compare.actionTypeCompare)(actionTypesIndex[a.id], actionTypesIndex[b.id], preconfiguredConnectors)).map(function (item, index) {
      const actionType = actionTypesIndex[item.id];
      const checkEnabledResult = (0, _check_action_type_enabled.checkActionFormActionTypeEnabled)(actionTypesIndex[item.id], preconfiguredConnectors);
      // if action type is not enabled in config and not preconfigured, it shouldn't be displayed
      if (!actionType.enabledInConfig && !checkEnabledResult.isEnabled) {
        return null;
      }
      if (!actionType.enabledInLicense) {
        hasDisabledByLicenseActionTypes = true;
      }
      const isSystemActionSelected = Boolean(actionTypesIndex[item.id].isSystemActionType && actions.find(action => action.actionTypeId === item.id));
      const isDisabled = !checkEnabledResult.isEnabled || isSystemActionSelected;
      const keyPadItem = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
        key: index,
        isDisabled: isDisabled,
        "data-test-subj": `${item.id}-${featureId}-ActionTypeSelectOption`,
        label: actionTypesIndex[item.id].name,
        betaBadgeLabel: item.isExperimental ? _translations.TECH_PREVIEW_LABEL : undefined,
        betaBadgeTooltipContent: item.isExperimental ? _translations.TECH_PREVIEW_DESCRIPTION : undefined,
        onClick: () => addActionType(item),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 328,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "xl",
        type: typeof item.iconClass === 'string' ? item.iconClass : (0, _suspended_component_with_props.suspendedComponentWithProps)(item.iconClass),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 337,
          columnNumber: 13
        }
      }));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `keypad-${item.id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 11
        }
      }, checkEnabledResult.isEnabled && keyPadItem, checkEnabledResult.isEnabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: checkEnabledResult.message,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 15
        }
      }, keyPadItem));
    });
  }
  return isLoadingConnectors ? /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionForm.loadingConnectorsDescription",
    defaultMessage: "Loading connectors\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideActionHeader && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions",
    id: "xpack.triggersActionsUI.sections.actionForm.actionSectionsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 11
    }
  })), actionTypesIndex && actions.map((actionItem, index) => {
    var _actionTypesIndex$act2;
    const isSystemActionType = Boolean((_actionTypesIndex$act2 = actionTypesIndex[actionItem.actionTypeId]) === null || _actionTypesIndex$act2 === void 0 ? void 0 : _actionTypesIndex$act2.isSystemActionType);
    const actionConnector = connectors.find(field => field.id === actionItem.id);
    const onDeleteAction = () => {
      const updatedActions = actions.filter((_item, i) => i !== index);
      setActions(updatedActions);
      setIsAddActionPanelOpen(updatedActions.filter(item => item.id !== actionItem.id).length === 0);
      setActiveActionItem(undefined);
    };
    if (isSystemActionType && !actionConnector) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 404,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.triggersActionsUI.sections.actionForm.unableToLoadSystemActionConnectorTitle",
          defaultMessage: "Unable to load connector",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 405,
            columnNumber: 21
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 402,
          columnNumber: 15
        }
      });
    }
    // If connector does not exist
    if (!actionConnector) {
      return /*#__PURE__*/_react.default.createElement(_connector_add_inline.AddConnectorInline, {
        actionTypesIndex: actionTypesIndex,
        actionItem: actionItem,
        index: index,
        key: `action-form-action-at-${index}`,
        actionTypeRegistry: actionTypeRegistry,
        emptyActionsIds: emptyActionsIds,
        connectors: connectors,
        onDeleteConnector: onDeleteAction,
        onAddConnector: () => {
          setActiveActionItem({
            actionTypeId: actionItem.actionTypeId,
            indices: actions.map((item, idx) => item.id === actionItem.id ? idx : -1).filter(idx => idx >= 0)
          });
          setAddModalVisibility(true);
        },
        onSelectConnector: connectorId => {
          setActionIdByIndex(connectorId, index);
          const newConnector = connectors.find(connector => connector.id === connectorId);
          if (newConnector && newConnector.actionTypeId) {
            const actionTypeRegistered = actionTypeRegistry.get(newConnector.actionTypeId);
            if (actionTypeRegistered.convertParamsBetweenGroups) {
              const updatedActions = actions.map((_item, i) => {
                if (i === index) {
                  return {
                    ..._item,
                    actionTypeId: newConnector.actionTypeId,
                    id: connectorId,
                    params: actionTypeRegistered.convertParamsBetweenGroups != null ? actionTypeRegistered.convertParamsBetweenGroups(_item.params) : {}
                  };
                }
                return _item;
              });
              setActions(updatedActions);
            }
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 417,
          columnNumber: 15
        }
      });
    }
    if (isSystemActionType) {
      return /*#__PURE__*/_react.default.createElement(_system_action_type_form.SystemActionTypeForm, {
        actionItem: actionItem,
        actionConnector: actionConnector,
        index: index,
        key: `system-action-form-action-at-${actionItem.uuid}`,
        setActionParamsProperty: setActionParamsProperty,
        actionTypesIndex: actionTypesIndex,
        connectors: connectors,
        messageVariables: messageVariables,
        summaryMessageVariables: summaryMessageVariables,
        defaultActionMessage: defaultActionMessage,
        actionTypeRegistry: actionTypeRegistry,
        onDeleteAction: onDeleteAction,
        defaultSummaryMessage: defaultSummaryMessage,
        featureId: featureId,
        producerId: producerId,
        ruleTypeId: ruleTypeId,
        disableErrorMessages: disableErrorMessages,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 467,
          columnNumber: 15
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_action_type_form.ActionTypeForm, {
      actionItem: actionItem,
      actionConnector: actionConnector,
      index: index,
      key: `action-form-action-at-${actionItem.uuid}`,
      setActionUseAlertDataForTemplate: setActionUseAlertDataForTemplate,
      setActionParamsProperty: setActionParamsProperty,
      setActionFrequencyProperty: setActionFrequencyProperty,
      setActionAlertsFilterProperty: setActionAlertsFilterProperty,
      actionTypesIndex: actionTypesIndex,
      connectors: connectors,
      defaultActionGroupId: defaultActionGroupId,
      messageVariables: messageVariables,
      summaryMessageVariables: summaryMessageVariables,
      actionGroups: actionGroups,
      defaultActionMessage: defaultActionMessage,
      recoveryActionGroup: recoveryActionGroup,
      isActionGroupDisabledForActionType: isActionGroupDisabledForActionType,
      setActionGroupIdByIndex: setActionGroupIdByIndex,
      onAddConnector: () => {
        setActiveActionItem({
          actionTypeId: actionItem.actionTypeId,
          indices: [index]
        });
        setAddModalVisibility(true);
      },
      onConnectorSelected: id => {
        setActionIdByIndex(id, index);
        const newConnector = connectors.find(connector => connector.id === id);
        if (newConnector && actionConnector && newConnector.actionTypeId !== actionConnector.actionTypeId) {
          const actionTypeRegistered = actionTypeRegistry.get(newConnector.actionTypeId);
          if (actionTypeRegistered.convertParamsBetweenGroups) {
            const updatedActions = actions.map((_item, i) => {
              if (i === index) {
                return {
                  ..._item,
                  actionTypeId: newConnector.actionTypeId,
                  id,
                  params: actionTypeRegistered.convertParamsBetweenGroups != null ? actionTypeRegistered.convertParamsBetweenGroups(_item.params) : {}
                };
              }
              return _item;
            });
            setActions(updatedActions);
          }
        }
      },
      actionTypeRegistry: actionTypeRegistry,
      onDeleteAction: () => {
        const updatedActions = actions.filter((_item, i) => i !== index);
        setActions(updatedActions);
        setIsAddActionPanelOpen(updatedActions.length === 0);
        setActiveActionItem(undefined);
      },
      hideNotifyWhen: hideNotifyWhen,
      defaultSummaryMessage: defaultSummaryMessage,
      hasAlertsMappings: hasAlertsMappings,
      minimumThrottleInterval: minimumThrottleInterval,
      notifyWhenSelectOptions: notifyWhenSelectOptions,
      featureId: featureId,
      producerId: producerId,
      ruleTypeId: ruleTypeId,
      disableErrorMessages: disableErrorMessages,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 13
      }
    });
  }), isAddActionPanelOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: "alertActionTypeTitle",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 564,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 565,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 567,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Select a connector type",
    id: "xpack.triggersActionsUI.sections.actionForm.selectConnectorTypeTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 568,
      columnNumber: 19
    }
  })))), hasDisabledByLicenseActionTypes && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 577,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _constants.VIEW_LICENSE_OPTIONS_LINK,
    target: "_blank",
    external: true,
    className: "actActionForm__getMoreActionsLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Get more connectors",
    id: "xpack.triggersActionsUI.sections.actionForm.getMoreConnectorsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 595,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 596,
      columnNumber: 11
    }
  }, isLoadingActionTypes ? /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 598,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionForm.loadingConnectorTypesDescription",
    defaultMessage: "Loading connector types\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 17
    }
  })) : actionTypeNodes)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "m",
    fullWidth: true,
    iconType: "plusInCircle",
    "data-test-subj": "addAlertActionButton",
    onClick: () => setIsAddActionPanelOpen(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 612,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionForm.addActionButtonLabel",
    defaultMessage: "Add action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 15
    }
  })))), actionTypesIndex && activeActionItem && addModalVisible ? /*#__PURE__*/_react.default.createElement(_.ConnectorAddModal, {
    actionType: actionTypesIndex[activeActionItem.actionTypeId],
    onClose: closeAddConnectorModal,
    postSaveEventHandler: savedAction => {
      // TODO: fix in https://github.com/elastic/kibana/issues/155993
      // actionTypes with subtypes need to be updated in case they switched to a
      // subtype that is not the default one
      activeActionItem.indices.forEach(index => {
        actions[index].actionTypeId = savedAction.actionTypeId;
      });
      connectors.push(savedAction);
      const indicesToUpdate = activeActionItem.indices || [];
      indicesToUpdate.forEach(index => setActionIdByIndex(savedAction.id, index));
    },
    actionTypeRegistry: actionTypeRegistry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 9
    }
  }) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ActionForm = ActionForm;