"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleConnectorForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/simple_connector_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseTextField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const UseComboBoxField = (0, _hook_form_lib.getUseField)({
  component: _components.ComboBoxField
});
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const getFieldConfig = ({
  label,
  isRequired = true,
  isUrlField = false,
  requireTld = true,
  defaultValue,
  type
}) => ({
  label,
  validations: [...(isRequired ? [{
    validator: emptyField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.requireFieldText', {
      values: {
        label
      },
      defaultMessage: `{label} is required.`
    }))
  }] : []), ...(isUrlField ? [{
    validator: urlField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.invalidURL', {
      defaultMessage: 'Invalid URL'
    }), {
      requireTld
    })
  }] : [])],
  defaultValue,
  ...(type && _hook_form_lib.FIELD_TYPES[type] ? {
    type: _hook_form_lib.FIELD_TYPES[type],
    defaultValue: Array.isArray(defaultValue) ? defaultValue : []
  } : {})
});
const getComponentByType = type => {
  let UseField = UseTextField;
  if (type && _hook_form_lib.FIELD_TYPES[type] === _hook_form_lib.FIELD_TYPES.COMBO_BOX) {
    UseField = UseComboBoxField;
  }
  return UseField;
};
const FormRow = ({
  id,
  label,
  readOnly,
  isPasswordField,
  isRequired = true,
  isUrlField,
  helpText,
  defaultValue,
  euiFieldProps = {},
  type,
  requireTld
}) => {
  const dataTestSub = `${id}-input`;
  const UseField = getComponentByType(type);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, !isPasswordField ? /*#__PURE__*/_react.default.createElement(UseField, {
    path: id,
    config: getFieldConfig({
      label,
      isUrlField,
      defaultValue,
      type,
      isRequired,
      requireTld
    }),
    helpText: helpText,
    componentProps: {
      euiFieldProps: {
        ...euiFieldProps,
        readOnly,
        fullWidth: true,
        'data-test-subj': dataTestSub
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(UseField, {
    path: id,
    config: getFieldConfig({
      label,
      type,
      isRequired
    }),
    helpText: helpText,
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        ...euiFieldProps,
        'data-test-subj': dataTestSub,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }))));
};
const SimpleConnectorFormComponent = ({
  isEdit,
  readOnly,
  configFormSchema,
  secretsFormSchema,
  configFormSchemaAfterSecrets = []
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configFormSchema.map(({
    id,
    ...restConfigSchema
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `config.${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FormRow, (0, _extends2.default)({
    id: `config.${id}`
  }, restConfigSchema, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  })), index !== configFormSchema.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 48
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.simpleConnectorForm.secrets.authenticationLabel', {
    defaultMessage: 'Authentication'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), secretsFormSchema.map(({
    id,
    ...restSecretsSchema
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `secrets.${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FormRow, (0, _extends2.default)({
    id: `secrets.${id}`,
    key: `secrets.${id}`
  }, restSecretsSchema, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), index !== secretsFormSchema.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 49
    }
  }) : null)), configFormSchemaAfterSecrets.map(({
    id,
    ...restConfigSchemaAfterSecrets
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `config.${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FormRow, (0, _extends2.default)({
    id: `config.${id}`
  }, restConfigSchemaAfterSecrets, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  })), index !== configFormSchemaAfterSecrets.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 60
    }
  }) : null)));
};
const SimpleConnectorForm = exports.SimpleConnectorForm = /*#__PURE__*/(0, _react.memo)(SimpleConnectorFormComponent);