"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = exports.ExpandedRowColumnView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/expanded_row_column_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Section = ({
  section
}) => {
  if (section.items.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: section.items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.Section = Section;
const ExpandedRowColumnView = ({
  sections,
  showErrorCallout = false,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'transformDetailsTabContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, showErrorCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.list.extendedStatsError",
    defaultMessage: "An error occurred fetching the extended stats for this transform. Basic stats are displayed instead.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, sections.filter(s => s.position === 'left').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, sections.filter(s => s.position === 'right').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }))))));
};
exports.ExpandedRowColumnView = ExpandedRowColumnView;