"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editActionNameText = exports.EditActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_edit/edit_action_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const editActionNameText = exports.editActionNameText = _i18n.i18n.translate('xpack.transform.transformList.editActionNameText', {
  defaultMessage: 'Edit'
});
const EditActionName = () => {
  const {
    canCreateTransform
  } = (0, _hooks.useTransformCapabilities)();
  if (!canCreateTransform) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _create_capability_failure_message.createCapabilityFailureMessage)('canStartStopTransform'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, editActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, editActionNameText);
};
exports.EditActionName = EditActionName;