"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _delete_action_name = require("./delete_action_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_delete/use_delete_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useDeleteAction = forceDisable => {
  const {
    canDeleteTransform
  } = (0, _hooks.useTransformCapabilities)();
  const deleteTransforms = (0, _hooks.useDeleteTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const isBulkAction = items.length > 1;
  const shouldForceDelete = (0, _react.useMemo)(() => items.some(i => {
    var _i$stats;
    return ((_i$stats = i.stats) === null || _i$stats === void 0 ? void 0 : _i$stats.state) === _constants.TRANSFORM_STATE.FAILED;
  }), [items]);
  const closeModal = () => setModalVisible(false);
  const {
    userCanDeleteIndex,
    userCanDeleteDataView,
    deleteDestIndex,
    dataViewExists,
    deleteDataView,
    toggleDeleteIndex,
    toggleDeleteDataView
  } = (0, _hooks.useDeleteIndexAndTargetIndex)(items);
  const deleteAndCloseModal = () => {
    var _items$0$stats;
    setModalVisible(false);
    const shouldDeleteDestIndex = userCanDeleteIndex && deleteDestIndex;
    const shouldDeleteDestDataView = userCanDeleteIndex && userCanDeleteDataView && dataViewExists && deleteDataView;
    // if we are deleting multiple transforms, then force delete all if at least one item has failed
    // else, force delete only when the item user picks has failed
    const forceDelete = isBulkAction ? shouldForceDelete : items[0] && items[0] && ((_items$0$stats = items[0].stats) === null || _items$0$stats === void 0 ? void 0 : _items$0$stats.state) === _constants.TRANSFORM_STATE.FAILED;
    deleteTransforms({
      transformsInfo: items.filter(_transform_list.isTransformListRowWithStats).map(i => ({
        id: i.config.id,
        state: i.stats.state
      })),
      deleteDestIndex: shouldDeleteDestIndex,
      deleteDestDataView: shouldDeleteDestDataView,
      forceDelete
    });
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_delete_action_name.DeleteActionName, {
      canDeleteTransform,
      disabled: (0, _delete_action_name.isDeleteActionDisabled)([item], forceDisable),
      isBulkAction: false,
      items: [item],
      forceDisable,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }),
    enabled: item => (0, _transform_list.isTransformListRowWithStats)(item) && !(0, _delete_action_name.isDeleteActionDisabled)([item], forceDisable) && canDeleteTransform,
    description: _delete_action_name.deleteActionNameText,
    icon: 'trash',
    type: 'icon',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionDelete'
  }), [canDeleteTransform, forceDisable]);
  return {
    action,
    closeModal,
    deleteAndCloseModal,
    deleteDestIndex,
    deleteDataView,
    dataViewExists,
    isModalVisible,
    items,
    openModal,
    shouldForceDelete,
    toggleDeleteIndex,
    toggleDeleteDataView,
    userCanDeleteIndex,
    userCanDeleteDataView
  };
};
exports.useDeleteAction = useDeleteAction;