"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _hooks = require("../../../../hooks");
var _app_dependencies = require("../../../../app_dependencies");
var _clone_action_name = require("./clone_action_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_clone/use_clone_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useCloneAction = (forceDisable, transformNodes) => {
  const history = (0, _reactRouterDom.useHistory)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    data: dataViewsTitleIdMap
  } = (0, _hooks.useGetDataViewsTitleIdMap)();
  const {
    canCreateTransform
  } = (0, _hooks.useTransformCapabilities)();
  const clickHandler = (0, _react.useCallback)(async item => {
    try {
      if (!dataViewsTitleIdMap) {
        return;
      }
      const dataViewTitle = Array.isArray(item.config.source.index) ? item.config.source.index.join(',') : item.config.source.index;
      const dataViewId = dataViewsTitleIdMap[dataViewTitle];
      if (dataViewId === undefined) {
        toastNotifications.addDanger(_i18n.i18n.translate('xpack.transform.clone.noDataViewErrorPromptText', {
          defaultMessage: 'Unable to clone the transform {transformId}. No data view exists for {dataViewTitle}.',
          values: {
            dataViewTitle,
            transformId: item.id
          }
        }));
      } else {
        history.push(`/${_constants.SECTION_SLUG.CLONE_TRANSFORM}/${item.id}?dataViewId=${dataViewId}`);
      }
    } catch (e) {
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.transform.clone.errorPromptText', {
          defaultMessage: 'An error occurred checking if source data view exists'
        })
      });
    }
  }, [dataViewsTitleIdMap, history, toastNotifications]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_clone_action_name.CloneActionName, {
      disabled: !canCreateTransform,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 41
      }
    }),
    enabled: () => dataViewsTitleIdMap !== undefined && canCreateTransform && !forceDisable && transformNodes > 0,
    description: _clone_action_name.cloneActionNameText,
    icon: 'copy',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'transformActionClone'
  }), [canCreateTransform, dataViewsTitleIdMap, forceDisable, clickHandler, transformNodes]);
  return {
    action
  };
};
exports.useCloneAction = useCloneAction;