"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyoutFormTextArea = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _edit_transform_flyout_state = require("../state_management/edit_transform_flyout_state");
var _form_field = require("../state_management/selectors/form_field");
var _capitalize_first_letter = require("../utils/capitalize_first_letter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/components/edit_transform_flyout_form_text_area.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditTransformFlyoutFormTextArea = ({
  field,
  label,
  helpText,
  placeHolder = false
}) => {
  const {
    defaultValue,
    errorMessages,
    value
  } = (0, _form_field.useFormField)(field);
  const {
    setFormField
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutActions)();
  const upperCaseField = (0, _capitalize_first_letter.capitalizeFirstLetter)(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    isInvalid: errorMessages.length > 0,
    error: errorMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": `transformEditFlyout${upperCaseField}Input`,
    placeholder: placeHolder ? _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormPlaceholderText', {
      defaultMessage: 'Default: {defaultValue}',
      values: {
        defaultValue
      }
    }) : undefined,
    isInvalid: errorMessages.length > 0,
    value: value,
    onChange: e => setFormField({
      field,
      value: e.target.value
    }),
    "aria-label": label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
exports.EditTransformFlyoutFormTextArea = EditTransformFlyoutFormTextArea;