"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntervalButtonStyles = exports.transformLabelStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntervalButtonStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    button: (0, _react.css)`
      width: ${euiTheme.size.l};
    `
  };
};
exports.useIntervalButtonStyles = useIntervalButtonStyles;
const transformLabelStyles = exports.transformLabelStyles = (0, _react.css)`
  min-width: 0;
`;