"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepCreateForm = void 0;
exports.getDefaultStepCreateState = getDefaultStepCreateState;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _common = require("@kbn/discover-plugin/common");
var _constants = require("../../../../../../common/constants");
var _errors = require("../../../../../../common/utils/errors");
var _common2 = require("../../../../common");
var _hooks = require("../../../../hooks");
var _app_dependencies = require("../../../../app_dependencies");
var _navigation = require("../../../../common/navigation");
var _components = require("../../../../components");
var _transform = require("../../../../../../common/types/transform");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_create/step_create_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getDefaultStepCreateState() {
  return {
    created: false,
    started: false,
    dataViewId: undefined
  };
}
const StepCreateForm = exports.StepCreateForm = /*#__PURE__*/_react.default.memo(({
  createDataView,
  transformConfig,
  transformId,
  onChange,
  overrides,
  timeFieldName
}) => {
  var _application$capabili, _application$capabili2;
  const defaults = {
    ...getDefaultStepCreateState(),
    ...overrides
  };
  const [redirectToTransformManagement, setRedirectToTransformManagement] = (0, _react.useState)(false);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [created, setCreated] = (0, _react.useState)(defaults.created);
  const [started, setStarted] = (0, _react.useState)(defaults.started);
  const [alertFlyoutVisible, setAlertFlyoutVisible] = (0, _react.useState)(false);
  const [dataViewId, setDataViewId] = (0, _react.useState)(defaults.dataViewId);
  const [progressPercentComplete, setProgressPercentComplete] = (0, _react.useState)(undefined);
  const [discoverLink, setDiscoverLink] = (0, _react.useState)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    application,
    share,
    ...startServices
  } = (0, _app_dependencies.useAppDependencies)();
  const isDiscoverAvailable = (_application$capabili = (_application$capabili2 = application.capabilities.discover_v2) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  (0, _react.useEffect)(() => {
    let unmounted = false;
    onChange({
      created,
      started,
      dataViewId
    });
    const getDiscoverUrl = async () => {
      const locator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
      if (!locator) return;
      const discoverUrl = await locator.getUrl({
        indexPatternId: dataViewId
      });
      if (!unmounted) {
        setDiscoverLink(discoverUrl);
      }
    };
    if (started === true && dataViewId !== undefined && isDiscoverAvailable) {
      getDiscoverUrl();
    }
    return () => {
      unmounted = true;
    };
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [created, started, dataViewId]);
  const startTransforms = (0, _hooks.useStartTransforms)();
  const createTransform = (0, _hooks.useCreateTransform)();
  function createTransformHandler(startAfterCreation = false) {
    setLoading(true);
    createTransform({
      transformId,
      transformConfig,
      createDataView,
      timeFieldName
    }, {
      onError: () => setCreated(false),
      onSuccess: resp => {
        setCreated(true);
        if (resp.dataViewsCreated.length === 1) {
          setDataViewId(resp.dataViewsCreated[0].id);
        }
        if (startAfterCreation) {
          startTransform();
        }
      },
      onSettled: () => setLoading(false)
    });
  }
  function startTransform() {
    setLoading(true);
    startTransforms([{
      id: transformId
    }], {
      onError: () => setStarted(false),
      onSuccess: resp => {
        var _resp$transformId;
        return setStarted(((_resp$transformId = resp[transformId]) === null || _resp$transformId === void 0 ? void 0 : _resp$transformId.success) === true);
      },
      onSettled: () => setLoading(false)
    });
  }
  const isBatchTransform = typeof transformConfig.sync === 'undefined';
  (0, _react.useEffect)(() => {
    if (loading === false && started === true && progressPercentComplete === undefined && isBatchTransform) {
      setProgressPercentComplete(0);
    }
  }, [loading, started, progressPercentComplete, isBatchTransform]);
  const progressBarRefetchEnabled = isBatchTransform && typeof progressPercentComplete === 'number' && progressPercentComplete < 100;
  const progressBarRefetchInterval = progressBarRefetchEnabled ? _constants.PROGRESS_REFRESH_INTERVAL_MS : false;
  const {
    data: stats
  } = (0, _hooks.useGetTransformStats)(transformId, false, progressBarRefetchEnabled, progressBarRefetchInterval);
  (0, _react.useEffect)(() => {
    if (stats === undefined) {
      return;
    }
    if (stats && Array.isArray(stats.transforms) && stats.transforms.length > 0) {
      const percent = (0, _common2.getTransformProgress)({
        id: transformId,
        config: {
          ...transformConfig,
          id: transformId
        },
        stats: stats.transforms[0]
      }) || 0;
      setProgressPercentComplete(percent);
    } else {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepCreateForm.progressErrorMessage', {
          defaultMessage: 'An error occurred getting the progress percentage:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(stats),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 13
          }
        }), startServices)
      });
    }
  }, [stats, toastNotifications, transformConfig, transformId, startServices]);
  function getTransformConfigDevConsoleStatement() {
    return `PUT _transform/${transformId}\n${JSON.stringify(transformConfig, null, 2)}\n\n`;
  }

  // TODO move this to SASS
  const FLEX_GROUP_STYLE = {
    height: '90px',
    maxWidth: '800px'
  };
  const FLEX_ITEM_STYLE = {
    width: '200px'
  };
  const PANEL_ITEM_STYLE = {
    width: '300px'
  };
  if (redirectToTransformManagement) {
    return /*#__PURE__*/_react.default.createElement(_navigation.RedirectToTransformManagement, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepCreateForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }, !created && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading || created && started,
    onClick: () => createTransformHandler(true),
    "data-test-subj": "transformWizardCreateAndStartButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAndStartTransformButton', {
    defaultMessage: 'Create and start'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAndStartTransformDescription', {
    defaultMessage: 'Creates and starts the transform. A transform will increase search and indexing load in your cluster. Please stop the transform if excessive load is experienced. After the transform is started, you will be offered options to continue exploring the transform.'
  })))), created && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading || created && started,
    onClick: startTransform,
    "data-test-subj": "transformWizardStartButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.startTransformButton', {
    defaultMessage: 'Start'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.startTransformDescription', {
    defaultMessage: 'Starts the transform. A transform will increase search and indexing load in your cluster. Please stop the transform if excessive load is experienced. After the transform is started, you will be offered options to continue exploring the transform.'
  })))), (0, _transform.isContinuousTransform)(transformConfig) && created ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: loading,
    onClick: setAlertFlyoutVisible.bind(null, true),
    "data-test-subj": "transformWizardCreateAlertButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepCreateForm.createAlertRuleButton",
    defaultMessage: "Create alert rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createAlertRuleDescription', {
    defaultMessage: 'Opens a wizard to create an alert rule for monitoring transform health.'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: loading || created,
    onClick: () => createTransformHandler(),
    "data-test-subj": "transformWizardCreateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createTransformButton', {
    defaultMessage: 'Create'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.createTransformDescription', {
    defaultMessage: 'Creates the transform without starting it. You will be able to start the transform later by returning to the transforms list.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: FLEX_GROUP_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: FLEX_ITEM_STYLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: getTransformConfigDevConsoleStatement(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 15
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: copy,
    style: {
      width: '100%'
    },
    "data-test-subj": "transformWizardCopyToClipboardButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.copyTransformConfigToClipboardButton', {
    defaultMessage: 'Copy to clipboard'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.copyTransformConfigToClipboardDescription', {
    defaultMessage: 'Copies to the clipboard the Kibana Dev Console command for creating the transform.'
  })))), progressPercentComplete !== undefined && isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.progressTitle', {
    defaultMessage: 'Progress'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '400px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "l",
    color: "primary",
    value: progressPercentComplete,
    max: 100,
    "data-test-subj": "transformWizardProgressBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 19
    }
  }, progressPercentComplete, "%")))), created && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "list",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 27
      }
    }),
    title: _i18n.i18n.translate('xpack.transform.stepCreateForm.transformListCardTitle', {
      defaultMessage: 'Transforms'
    }),
    description: _i18n.i18n.translate('xpack.transform.stepCreateForm.transformListCardDescription', {
      defaultMessage: 'Return to the transform management page.'
    }),
    onClick: () => setRedirectToTransformManagement(true),
    "data-test-subj": "transformWizardCardManagement",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 19
    }
  })), started === true && createDataView === true && dataViewId === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 25
    }
  }, _i18n.i18n.translate('xpack.transform.stepCreateForm.creatingDataViewMessage', {
    defaultMessage: 'Creating Kibana data view ...'
  }))))), isDiscoverAvailable && discoverLink !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: PANEL_ITEM_STYLE,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "discoverApp",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 29
      }
    }),
    title: _i18n.i18n.translate('xpack.transform.stepCreateForm.discoverCardTitle', {
      defaultMessage: 'Discover'
    }),
    description: _i18n.i18n.translate('xpack.transform.stepCreateForm.discoverCardDescription', {
      defaultMessage: 'Use Discover to explore the transform.'
    }),
    href: discoverLink,
    "data-test-subj": "transformWizardCardDiscover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 21
    }
  }))))), alertFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.TransformAlertFlyout, {
    ruleParams: {
      includeTransforms: [transformId]
    },
    onCloseFlyout: setAlertFlyoutVisible.bind(null, false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 11
    }
  }) : null);
});