"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSourceEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/advanced_source_editor/advanced_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedSourceEditor = ({
  searchBar: {
    actions: {
      setSearchString
    }
  },
  advancedSourceEditor: {
    actions: {
      setAdvancedEditorSourceConfig,
      setAdvancedSourceEditorApplyButtonEnabled
    },
    state: {
      advancedEditorSourceConfig,
      advancedEditorSourceConfigLastApplied
    }
  }
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformAdvancedRuntimeMappingsEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 250,
    languageId: 'json',
    onChange: d => {
      setSearchString(undefined);
      setAdvancedEditorSourceConfig(d);

      // Disable the "Apply"-Button if the config hasn't changed.
      if (advancedEditorSourceConfigLastApplied === d) {
        setAdvancedSourceEditorApplyButtonEnabled(false);
        return;
      }

      // Try to parse the string passed on from the editor.
      // If parsing fails, the "Apply"-Button will be disabled
      try {
        JSON.parse(d);
        setAdvancedSourceEditorApplyButtonEnabled(true);
      } catch (e) {
        setAdvancedSourceEditorApplyButtonEnabled(false);
      }
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorAriaLabel', {
        defaultMessage: 'Advanced query editor'
      }),
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: advancedEditorSourceConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }));
};
exports.AdvancedSourceEditor = AdvancedSourceEditor;