"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedQueryEditorSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _switch_modal = require("../switch_modal");
var _step_define = require("../step_define");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/advanced_query_editor_switch/advanced_query_editor_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedQueryEditorSwitch = ({
  advancedSourceEditor: {
    actions: {
      setAdvancedSourceEditorSwitchModalVisible,
      setSourceConfigUpdated,
      toggleAdvancedSourceEditor
    },
    state: {
      isAdvancedSourceEditorEnabled,
      isAdvancedSourceEditorSwitchModalVisible,
      sourceConfigUpdated,
      advancedEditorSourceConfigLastApplied,
      advancedEditorSourceConfig
    }
  },
  searchBar: {
    actions: {
      setSearchQuery
    }
  }
}) => {
  // If switching to KQL after updating via editor - reset search
  const toggleEditorHandler = (reset = false) => {
    if (reset === true) {
      setSearchQuery(_step_define.defaultSearch);
      setSourceConfigUpdated(false);
    }
    toggleAdvancedSourceEditor(reset);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSourceConfigSwitchLabel', {
      defaultMessage: 'Edit JSON query'
    }),
    checked: isAdvancedSourceEditorEnabled,
    onChange: () => {
      if (isAdvancedSourceEditorEnabled && (sourceConfigUpdated || advancedEditorSourceConfig !== advancedEditorSourceConfigLastApplied)) {
        setAdvancedSourceEditorSwitchModalVisible(true);
        return;
      }
      toggleEditorHandler();
    },
    "data-test-subj": "transformAdvancedQueryEditorSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), isAdvancedSourceEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setAdvancedSourceEditorSwitchModalVisible(false),
    onConfirm: () => {
      setAdvancedSourceEditorSwitchModalVisible(false);
      toggleEditorHandler(true);
    },
    type: 'source',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }));
};
exports.AdvancedQueryEditorSwitch = AdvancedQueryEditorSwitch;