"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTransformNodes = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetTransformNodes = ({
  enabled
} = {
  enabled: true
}) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORM_NODES], async ({
    signal
  }) => {
    const transformNodes = await http.get((0, _constants.addInternalBasePath)('transforms/_nodes'), {
      version: '1',
      signal
    });
    return transformNodes.count;
  }, {
    refetchInterval: _constants.DEFAULT_REFRESH_INTERVAL_MS,
    enabled
  });
};
exports.useGetTransformNodes = useGetTransformNodes;