"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dateHistogramIntervalFormatRegex = exports.PIVOT_SUPPORTED_GROUP_BY_AGGS = void 0;
exports.getEsAggFromGroupByConfig = getEsAggFromGroupByConfig;
exports.histogramIntervalFormatRegex = void 0;
exports.isGroupByDateHistogram = isGroupByDateHistogram;
exports.isGroupByHistogram = isGroupByHistogram;
exports.isGroupByTerms = isGroupByTerms;
exports.isPivotAggConfigWithUiSupport = isPivotAggConfigWithUiSupport;
exports.isPivotGroupByConfigWithUiSupport = isPivotGroupByConfigWithUiSupport;
exports.pivotGroupByFieldSupport = void 0;
var _fieldTypes = require("@kbn/field-types");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let PIVOT_SUPPORTED_GROUP_BY_AGGS = exports.PIVOT_SUPPORTED_GROUP_BY_AGGS = /*#__PURE__*/function (PIVOT_SUPPORTED_GROUP_BY_AGGS) {
  PIVOT_SUPPORTED_GROUP_BY_AGGS["DATE_HISTOGRAM"] = "date_histogram";
  PIVOT_SUPPORTED_GROUP_BY_AGGS["HISTOGRAM"] = "histogram";
  PIVOT_SUPPORTED_GROUP_BY_AGGS["TERMS"] = "terms";
  return PIVOT_SUPPORTED_GROUP_BY_AGGS;
}({});
const pivotGroupByFieldSupport = exports.pivotGroupByFieldSupport = {
  [_fieldTypes.KBN_FIELD_TYPES.ATTACHMENT]: [],
  [_fieldTypes.KBN_FIELD_TYPES.BOOLEAN]: [PIVOT_SUPPORTED_GROUP_BY_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES.DATE]: [PIVOT_SUPPORTED_GROUP_BY_AGGS.DATE_HISTOGRAM],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_POINT]: [],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE]: [],
  [_fieldTypes.KBN_FIELD_TYPES.IP]: [PIVOT_SUPPORTED_GROUP_BY_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES.MURMUR3]: [],
  [_fieldTypes.KBN_FIELD_TYPES.NUMBER]: [PIVOT_SUPPORTED_GROUP_BY_AGGS.HISTOGRAM, PIVOT_SUPPORTED_GROUP_BY_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES.STRING]: [PIVOT_SUPPORTED_GROUP_BY_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES._SOURCE]: [],
  [_fieldTypes.KBN_FIELD_TYPES.UNKNOWN]: [],
  [_fieldTypes.KBN_FIELD_TYPES.CONFLICT]: []
};
// Don't allow an interval of '0', but allow a float interval of '0.1' with a leading zero.
const histogramIntervalFormatRegex = exports.histogramIntervalFormatRegex = /^([1-9][0-9]*((\.)([0-9]+))?|([0](\.)([0-9]+)))$/;
// Don't allow intervals of '0', don't allow floating intervals.
const dateHistogramIntervalFormatRegex = exports.dateHistogramIntervalFormatRegex = /^[1-9][0-9]*(ms|s|m|h|d|w|M|q|y)$/;
function isGroupByDateHistogram(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field', 'calendar_interval']) && arg.agg === PIVOT_SUPPORTED_GROUP_BY_AGGS.DATE_HISTOGRAM;
}
function isGroupByHistogram(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field', 'interval']) && arg.agg === PIVOT_SUPPORTED_GROUP_BY_AGGS.HISTOGRAM;
}
function isGroupByTerms(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field']) && arg.agg === PIVOT_SUPPORTED_GROUP_BY_AGGS.TERMS;
}
function isPivotGroupByConfigWithUiSupport(arg) {
  return isGroupByDateHistogram(arg) || isGroupByHistogram(arg) || isGroupByTerms(arg);
}
function getEsAggFromGroupByConfig(groupByConfig) {
  const {
    agg,
    aggName,
    dropDownName,
    ...esAgg
  } = groupByConfig;
  return {
    [agg]: esAgg
  };
}
function isPivotAggConfigWithUiSupport(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field']);
}