"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortItem = exports.sort = void 0;
var _zod = require("@kbn/zod");
var _order = require("./order");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortItem = exports.sortItem = _zod.z.object({
  direction: _order.order,
  field: _zod.z.string(),
  esTypes: _zod.z.array(_zod.z.string()).optional(),
  type: _zod.z.string().optional()
});
const sort = exports.sort = _zod.z.array(sortItem);