"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInStatusNoticeBanner = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _opt_in_message = require("./opt_in_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/telemetry/public/components/opt_in_status_notice_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint @elastic/eui/href-or-on-click:0 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OptInStatusNoticeBanner = ({
  onSeenBanner,
  http,
  telemetryConstants,
  telemetryService
}) => {
  const addBasePath = http.basePath.prepend;
  const bannerTitle = _i18n.i18n.translate('telemetry.telemetryOptedInNoticeTitle', {
    defaultMessage: 'Help us improve the Elastic Stack'
  });
  return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    title: bannerTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement(_opt_in_message.OptInMessage, {
    telemetryConstants: telemetryConstants,
    telemetryService: telemetryService,
    addBasePath: addBasePath,
    onClick: onSeenBanner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onSeenBanner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.telemetryOptedInDismissMessage",
    defaultMessage: "Dismiss",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })));
};
exports.OptInStatusNoticeBanner = OptInStatusNoticeBanner;