"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectTasksByCapacity = selectTasksByCapacity;
var _task_claiming = require("../../queries/task_claiming");
var _task_type_dictionary = require("../../task_type_dictionary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// given a list of tasks and capacity info, select the tasks that meet capacity
function selectTasksByCapacity({
  definitions,
  tasks,
  batches
}) {
  // create a map of task type - concurrency
  const limitedBatches = batches.filter(_task_claiming.isLimited);
  const limitedMap = new Map();
  for (const limitedBatch of limitedBatches) {
    var _taskDef$maxConcurren;
    const {
      tasksTypes: taskType
    } = limitedBatch;

    // get concurrency from task definition
    const taskDef = definitions.get(taskType);
    limitedMap.set(taskType, (_taskDef$maxConcurren = taskDef === null || taskDef === void 0 ? void 0 : taskDef.maxConcurrency) !== null && _taskDef$maxConcurren !== void 0 ? _taskDef$maxConcurren : null);
  }

  // apply the limited concurrency
  const result = [];
  for (const task of tasks) {
    // get concurrency of this task type
    const concurrency = limitedMap.get(task.taskType);
    if (concurrency == null) {
      result.push(task);
      continue;
    }
    if (concurrency > 0) {
      result.push(task);

      // get any shared concurrency task types
      const sharesConcurrencyWith = (0, _task_type_dictionary.sharedConcurrencyTaskTypes)(task.taskType);
      if (sharesConcurrencyWith) {
        for (const taskType of sharesConcurrencyWith) {
          if (limitedMap.has(taskType)) {
            limitedMap.set(taskType, concurrency - 1);
          }
        }
      } else {
        limitedMap.set(task.taskType, concurrency - 1);
      }
    }
  }
  return result;
}