"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupPrivateLocationRoute = void 0;
var _feature = require("../../../feature");
var _constants = require("../../../../common/constants");
var _sync_private_locations_monitors_task = require("../../../tasks/sync_private_locations_monitors_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanupPrivateLocationRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_CLEANUP,
  validate: {},
  requiredPrivileges: [_feature.PRIVATE_LOCATION_WRITE_API],
  handler: async routeContext => {
    const {
      server
    } = routeContext;
    await (0, _sync_private_locations_monitors_task.resetSyncPrivateCleanUpState)({
      server
    });
    return {
      success: true,
      message: 'Task to start clean up has been started, it may take a while.'
    };
  }
});
exports.cleanupPrivateLocationRoute = cleanupPrivateLocationRoute;