"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateLocationRepository = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _get_agent_policies = require("../routes/settings/private_locations/get_agent_policies");
var _private_locations = require("../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrivateLocationRepository {
  constructor(routeContext) {
    (0, _defineProperty2.default)(this, "internalSOClient", void 0);
    this.routeContext = routeContext;
    const {
      server
    } = routeContext;
    this.internalSOClient = server.coreStart.savedObjects.createInternalRepository();
  }
  async createPrivateLocation(formattedLocation, newId) {
    const {
      savedObjectsClient
    } = this.routeContext;
    const {
      spaces
    } = formattedLocation;
    return await savedObjectsClient.create(_private_locations.privateLocationSavedObjectName, formattedLocation, {
      id: newId,
      initialNamespaces: (0, _lodash.isEmpty)(spaces) || spaces !== null && spaces !== void 0 && spaces.includes('*') ? ['*'] : spaces
    });
  }
  async getPrivateLocation(locationId) {
    const {
      savedObjectsClient
    } = this.routeContext;
    return savedObjectsClient.get(_private_locations.privateLocationSavedObjectName, locationId);
  }
  async editPrivateLocation(locationId, newAttributes) {
    const {
      savedObjectsClient
    } = this.routeContext;
    return savedObjectsClient.update(_private_locations.privateLocationSavedObjectName, locationId, newAttributes);
  }
  async validatePrivateLocation() {
    const {
      response,
      request,
      server
    } = this.routeContext;
    let errorMessages = '';
    const location = request.body;
    const {
      spaces
    } = location;
    const [data, agentPolicies] = await Promise.all([this.internalSOClient.find({
      type: _private_locations.privateLocationSavedObjectName,
      perPage: 10000,
      namespaces: spaces
    }), await (0, _get_agent_policies.getAgentPoliciesAsInternalUser)({
      server
    })]);
    const locations = data.saved_objects.map(loc => ({
      ...loc.attributes,
      spaces: loc.attributes.spaces || loc.namespaces
    }));
    const locWithAgentPolicyId = locations.find(loc => loc.agentPolicyId === location.agentPolicyId);
    if (locWithAgentPolicyId) {
      errorMessages = _i18n.i18n.translate('xpack.synthetics.privateLocations.create.errorMessages.policyExists', {
        defaultMessage: `Private location with agentPolicyId {agentPolicyId} already exists in spaces {spaces}`,
        values: {
          agentPolicyId: location.agentPolicyId,
          spaces: formatSpaces(locWithAgentPolicyId.spaces)
        }
      });
    }

    // return if name is already taken
    const locWithSameLabel = locations.find(loc => loc.label === location.label);
    if (locWithSameLabel) {
      errorMessages = _i18n.i18n.translate('xpack.synthetics.privateLocations.create.errorMessages.labelExists', {
        defaultMessage: `Private location with label {label} already exists in spaces: {spaces}`,
        values: {
          label: location.label,
          spaces: formatSpaces(locWithSameLabel.spaces)
        }
      });
    }
    const agentPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(policy => policy.id === location.agentPolicyId);
    if (!agentPolicy) {
      errorMessages = `Agent policy with id ${location.agentPolicyId} does not exist`;
    }
    if (errorMessages) {
      return response.badRequest({
        body: {
          message: errorMessages
        }
      });
    }
  }
}
exports.PrivateLocationRepository = PrivateLocationRepository;
const formatSpaces = spaces => {
  var _spaces$map$join;
  return (_spaces$map$join = spaces === null || spaces === void 0 ? void 0 : spaces.map(space => space === '*' ? _i18n.i18n.translate('xpack.synthetics.formatSpaces.', {
    defaultMessage: '* All Spaces'
  }) : space).join(', ')) !== null && _spaces$map$join !== void 0 ? _spaces$map$join : 'Unknown';
};