"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilters = void 0;
exports.queryFilterMonitors = queryFilterMonitors;
var _esQuery = require("@kbn/es-query");
var _constants = require("@kbn/security-plugin/common/constants");
var _client_defaults = require("../../../../common/constants/client_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function queryFilterMonitors({
  spaceId,
  esClient,
  ruleParams
}) {
  var _result$aggregations;
  if (!ruleParams.kqlQuery) {
    return;
  }
  let kueryNode;

  // This is to check if the kqlQuery is valid, if it is not the fromKueryExpression will throw an error
  try {
    kueryNode = (0, _esQuery.fromKueryExpression)(ruleParams.kqlQuery);
  } catch (error) {
    return;
  }
  const filters = (0, _esQuery.toElasticsearchQuery)(kueryNode);
  const {
    body: result
  } = await esClient.search({
    size: 0,
    query: {
      bool: {
        filter: [_client_defaults.FINAL_SUMMARY_FILTER, (0, _client_defaults.getRangeFilter)({
          from: 'now-24h/m',
          to: 'now/m'
        }), (0, _client_defaults.getTimeSpanFilter)(), {
          terms: {
            'meta.space_id': [spaceId, _constants.ALL_SPACES_ID]
          }
        }, {
          bool: {
            should: filters
          }
        }, ...getFilters(ruleParams)]
      }
    },
    aggs: {
      ids: {
        terms: {
          size: 10000,
          field: 'config_id'
        }
      }
    }
  }, 'queryFilterMonitors');
  return (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.ids.buckets.map(bucket => bucket.key);
}
const getFilters = ruleParams => {
  const {
    monitorTypes,
    locations,
    tags,
    projects
  } = ruleParams;
  const filters = [];
  if (monitorTypes !== null && monitorTypes !== void 0 && monitorTypes.length) {
    filters.push({
      terms: {
        'monitor.type': monitorTypes
      }
    });
  }
  if (locations !== null && locations !== void 0 && locations.length) {
    filters.push({
      terms: {
        'observer.name': locations
      }
    });
  }
  if (tags !== null && tags !== void 0 && tags.length) {
    filters.push({
      terms: {
        tags
      }
    });
  }
  if (projects !== null && projects !== void 0 && projects.length) {
    filters.push({
      terms: {
        'monitor.project.id': projects
      }
    });
  }
  return filters;
};
exports.getFilters = getFilters;