"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormWrapped = useFormWrapped;
var _react = require("react");
var _reactHookForm = require("react-hook-form");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFormWrapped(props) {
  const {
    register,
    trigger,
    ...restOfForm
  } = (0, _reactHookForm.useForm)(props);
  const [changed, setChanged] = (0, _react.useState)(false);
  (0, _useDebounce.default)(async () => {
    if (changed) {
      await (trigger === null || trigger === void 0 ? void 0 : trigger()); // Manually invalidate whole form to make dependency validations reactive
    }
  }, 500, [changed]);

  // Wrap `onChange` to validate form to trigger validations
  const euiOnChange = (0, _react.useCallback)(onChange => {
    return async event => {
      setChanged(false);
      const onChangeResult = await onChange(event);
      setChanged(true);
      return onChangeResult;
    };
  }, [setChanged]);

  // Wrap react-hook-form register method to wire `onChange` and `inputRef`
  const euiRegister = (0, _react.useCallback)((name, ...registerArgs) => {
    const {
      ref,
      onChange,
      ...restOfRegister
    } = register(name, ...registerArgs);
    return {
      inputRef: ref,
      ref,
      onChange: euiOnChange(onChange),
      ...restOfRegister
    };
  }, [register, euiOnChange]);
  return {
    register: euiRegister,
    trigger,
    ...restOfForm
  };
}