"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDateFormat = useDateFormat;
var _moment = _interopRequireDefault(require("moment"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDateFormat() {
  const kibanaLocale = _i18n.i18n.getLocale();
  const clientLocale = navigator.language;
  (0, _react.useEffect)(() => {
    const preferredLocale = kibanaLocale !== null && kibanaLocale !== void 0 ? kibanaLocale : clientLocale;
    if (_moment.default.locale() !== preferredLocale) {
      _moment.default.locale(preferredLocale);
    }
  }, [kibanaLocale, clientLocale]);
  return timestamp => {
    if (!timestamp) return '';
    const date = (0, _moment.default)(timestamp);
    return `${date.format('ll')} @ ${date.format('LTS')}`;
  };
}