"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSupportedUrlParams = void 0;
var _state = require("../../state");
var _client_defaults = require("../../../../../common/constants/synthetics/client_defaults");
var _constants = require("../../../../../common/constants");
var _parse_absolute_date = require("./parse_absolute_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Change for Synthetics App if needed (Copied from legacy_uptime)

const {
  ABSOLUTE_DATE_RANGE_START,
  ABSOLUTE_DATE_RANGE_END,
  SEARCH,
  FILTERS,
  STATUS_FILTER
} = _constants.CLIENT_DEFAULTS;
const {
  DATE_RANGE_START,
  DATE_RANGE_END
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;

/**
 * Gets the current URL values for the application. If no item is present
 * for the URL, a default value is supplied.
 *
 * @param params A set of key-value pairs where the value is either
 * undefined or a string/string array. If a string array is passed,
 * only the first item is chosen. Support for lists in the URL will
 * require further development.
 */
const getSupportedUrlParams = params => {
  const filteredParams = {};
  Object.keys(params).forEach(key => {
    let value;
    if (params[key] === undefined) {
      value = undefined;
    } else if (Array.isArray(params[key])) {
      // @ts-ignore this must be an array, and it's ok if the
      // 0th element is undefined
      value = params[key][0];
    } else {
      // @ts-ignore this will not be an array because the preceding
      // block tests for that
      value = params[key];
    }
    filteredParams[key] = value;
  });
  const {
    dateRangeStart,
    dateRangeEnd,
    filters,
    excludedFilters,
    search,
    statusFilter,
    pagination,
    focusConnectorField,
    query,
    tags,
    monitorTypes,
    locations,
    locationId,
    projects,
    schedules,
    groupBy,
    groupOrderBy,
    packagePolicyId,
    spaceId,
    useLogicalAndFor,
    view
  } = filteredParams;
  return {
    packagePolicyId: packagePolicyId || undefined,
    groupBy: groupBy,
    groupOrderBy: groupOrderBy,
    pagination,
    absoluteDateRangeStart: (0, _parse_absolute_date.parseAbsoluteDate)(dateRangeStart || DATE_RANGE_START, ABSOLUTE_DATE_RANGE_START),
    absoluteDateRangeEnd: (0, _parse_absolute_date.parseAbsoluteDate)(dateRangeEnd || DATE_RANGE_END, ABSOLUTE_DATE_RANGE_END, {
      roundUp: true
    }),
    dateRangeStart: dateRangeStart || DATE_RANGE_START,
    dateRangeEnd: dateRangeEnd || DATE_RANGE_END,
    filters: filters || FILTERS,
    excludedFilters: excludedFilters || '',
    search: search || SEARCH,
    statusFilter: statusFilter || STATUS_FILTER,
    focusConnectorField: !!focusConnectorField,
    query: query || '',
    tags: parseFilters(tags),
    monitorTypes: parseFilters(monitorTypes),
    locations: parseFilters(locations),
    projects: parseFilters(projects),
    schedules: parseFilters(schedules),
    locationId: locationId || undefined,
    cloneId: filteredParams.cloneId,
    spaceId: spaceId || undefined,
    useLogicalAndFor: parseFilters(useLogicalAndFor),
    view: view && (0, _state.isOverviewView)(view) && view !== _state.DEFAULT_OVERVIEW_VIEW ? view : undefined
  };
};
exports.getSupportedUrlParams = getSupportedUrlParams;
const parseFilters = filters => {
  if (!filters) {
    return [];
  }
  try {
    return JSON.parse(filters);
  } catch (e) {
    return [filters];
  }
};