"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorSpaceToAppend = void 0;
exports.useEditMonitorLocator = useEditMonitorLocator;
var _react = require("react");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/security-plugin/public");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitorSpaceToAppend = (space, spaces) => {
  if (spaces !== null && spaces !== void 0 && spaces.includes(_public2.ALL_SPACES_ID)) {
    return {};
  }
  return space && spaces !== null && spaces !== void 0 && spaces.length && !(spaces !== null && spaces !== void 0 && spaces.includes(space === null || space === void 0 ? void 0 : space.id)) ? {
    spaceId: spaces[0]
  } : {};
};
exports.getMonitorSpaceToAppend = getMonitorSpaceToAppend;
function useEditMonitorLocator({
  configId,
  locators,
  spaces
}) {
  var _useKibana$services$s, _ref;
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const [editUrl, setEditUrl] = (0, _react.useState)(undefined);
  const syntheticsLocators = (_useKibana$services$s = (0, _public.useKibana)().services.share) === null || _useKibana$services$s === void 0 ? void 0 : _useKibana$services$s.url.locators;
  const locator = (_ref = locators || syntheticsLocators) === null || _ref === void 0 ? void 0 : _ref.get(_common.syntheticsEditMonitorLocatorID);
  (0, _react.useEffect)(() => {
    async function generateUrl() {
      const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        configId,
        ...getMonitorSpaceToAppend(space, spaces)
      }));
      setEditUrl(url);
    }
    generateUrl();
  }, [locator, configId, space, spaces]);
  return editUrl;
}