"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/step_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepTabs = ({
  stepsList,
  step,
  loading
}) => {
  var _step$synthetics$step;
  let tabs = [{
    id: 'code',
    name: CODE_EXECUTED
  }, {
    id: 'console',
    name: CONSOLE_LABEL
  }];
  const isFailedStep = (step === null || step === void 0 ? void 0 : (_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  if (isFailedStep) {
    tabs = [{
      id: 'stackTrace',
      name: STACKTRACE_LABEL
    }, ...tabs];
  }
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('code');
  (0, _react.useEffect)(() => {
    if (isFailedStep) {
      setSelectedTabId('stackTrace');
    } else {
      setSelectedTabId('code');
    }
  }, [isFailedStep]);
  const getBrowserConsoles = (0, _react.useCallback)(index => {
    return stepsList === null || stepsList === void 0 ? void 0 : stepsList.filter(stepF => {
      var _stepF$synthetics, _stepF$synthetics2, _stepF$synthetics2$st;
      return ((_stepF$synthetics = stepF.synthetics) === null || _stepF$synthetics === void 0 ? void 0 : _stepF$synthetics.type) === 'journey/browserconsole' && ((_stepF$synthetics2 = stepF.synthetics) === null || _stepF$synthetics2 === void 0 ? void 0 : (_stepF$synthetics2$st = _stepF$synthetics2.step) === null || _stepF$synthetics2$st === void 0 ? void 0 : _stepF$synthetics2$st.index) === index;
    }).map(stepF => {
      var _stepF$synthetics3, _stepF$synthetics3$pa;
      return (_stepF$synthetics3 = stepF.synthetics) === null || _stepF$synthetics3 === void 0 ? void 0 : (_stepF$synthetics3$pa = _stepF$synthetics3.payload) === null || _stepF$synthetics3$pa === void 0 ? void 0 : _stepF$synthetics3$pa.text;
    });
  }, [stepsList]);
  if (!loading && (stepsList === null || stepsList === void 0 ? void 0 : stepsList.length) === 0) {
    return null;
  }
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
  };
  const renderTabs = () => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: index,
      onClick: () => onSelectedTabChanged(tab.id),
      isSelected: tab.id === selectedTabId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, tab.name));
  };
  const renderTabContent = () => {
    var _step$synthetics, _step$synthetics$payl, _getBrowserConsoles, _step$synthetics$step2, _step$synthetics2, _step$synthetics2$ste, _step$synthetics3, _step$synthetics3$err, _step$synthetics4, _step$synthetics4$pay;
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 14
        }
      });
    }
    switch (selectedTabId) {
      case 'code':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 11
          }
        }, step === null || step === void 0 ? void 0 : (_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$payl = _step$synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.source);
      case 'console':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 11
          }
        }, (_getBrowserConsoles = getBrowserConsoles((_step$synthetics$step2 = step === null || step === void 0 ? void 0 : (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index) !== null && _step$synthetics$step2 !== void 0 ? _step$synthetics$step2 : 1)) === null || _getBrowserConsoles === void 0 ? void 0 : _getBrowserConsoles.join('\n'));
      case 'stackTrace':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "html",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 11
          }
        }, step === null || step === void 0 ? void 0 : (_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$err = _step$synthetics3.error) === null || _step$synthetics3$err === void 0 ? void 0 : _step$synthetics3$err.stack);
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 11
          }
        }, step === null || step === void 0 ? void 0 : (_step$synthetics4 = step.synthetics) === null || _step$synthetics4 === void 0 ? void 0 : (_step$synthetics4$pay = _step$synthetics4.payload) === null || _step$synthetics4$pay === void 0 ? void 0 : _step$synthetics4$pay.source);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, renderTabs()), renderTabContent());
};
exports.StepTabs = StepTabs;
const CODE_EXECUTED = _i18n.i18n.translate('xpack.synthetics.testDetails.codeExecuted', {
  defaultMessage: 'Code executed'
});
const STACKTRACE_LABEL = _i18n.i18n.translate('xpack.synthetics.testDetails.stackTrace', {
  defaultMessage: 'Stacktrace'
});
const CONSOLE_LABEL = _i18n.i18n.translate('xpack.synthetics.testDetails.console', {
  defaultMessage: 'Console'
});