"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepNumberNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/components/step_number_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepNumberNav = ({
  stepIndex,
  totalSteps,
  handleNextStep,
  handlePreviousStep
}) => {
  const hasPreviousStep = stepIndex > 1;
  const hasNextStep = stepIndex < totalSteps;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNumberNavButton",
    onClick: handlePreviousStep,
    disabled: !hasPreviousStep,
    iconType: "arrowLeft",
    "aria-label": PREVIOUS_STEP_BUTTON_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 13
    }
  }, PREVIOUS_STEP_BUTTON_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.testDetails.stepNav",
    defaultMessage: "{stepIndex} / {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNumberNavButton",
    onClick: handleNextStep,
    disabled: !hasNextStep,
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": NEXT_STEP_BUTTON_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, NEXT_STEP_BUTTON_TEXT)))));
};
exports.StepNumberNav = StepNumberNav;
const PREVIOUS_STEP_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.previousStepButtonText', {
  defaultMessage: 'Previous'
});
const PREVIOUS_STEP_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.previousStepButtonAriaLabel', {
  defaultMessage: 'Previous step'
});
const NEXT_STEP_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.nextStepButtonText', {
  defaultMessage: 'Next'
});
const NEXT_STEP_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.nextStepButtonAriaLabel', {
  defaultMessage: 'Next step'
});