"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListExpandedRowComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ping_redirects = require("./ping_redirects");
var _headers = require("./headers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/simple/ping_list/expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BodyDescription = ({
  body
}) => {
  const contentBytes = body.content_bytes || 0;
  const bodyBytes = body.bytes || 0;
  const truncatedText = contentBytes > 0 && contentBytes < bodyBytes ? _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.truncated', {
    defaultMessage: 'Showing first {contentBytes} bytes.',
    values: {
      contentBytes
    }
  }) : null;
  const bodySizeText = bodyBytes > 0 ? _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.bodySize', {
    defaultMessage: 'Body size is {bodyBytes}.',
    values: {
      bodyBytes: (0, _eui.formatNumber)(bodyBytes, '0b')
    }
  }) : null;
  const combinedText = [truncatedText, bodySizeText].filter(s => s).join(' ');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 10
    }
  }, combinedText);
};
const BodyExcerpt = ({
  content
}) => content ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  overflowHeight: 250,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 13
  }
}, content) : null;
const PingListExpandedRowComponent = ({
  ping
}) => {
  var _ping$http, _ping$http$response, _ping$http2, _ping$http2$response, _ping$http3, _ping$http3$response, _ping$http4, _ping$http4$response;
  const listItems = [];

  // Show the error block
  if (ping.error) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.error', {
        defaultMessage: 'Error'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 20
        }
      }, ping.error.message)
    });
  }

  // Show the body, if present
  if ((_ping$http = ping.http) !== null && _ping$http !== void 0 && (_ping$http$response = _ping$http.response) !== null && _ping$http$response !== void 0 && _ping$http$response.body) {
    const body = ping.http.response.body;
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.response_body', {
        defaultMessage: 'Response Body'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BodyDescription, {
        body: body,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }), body.content ? /*#__PURE__*/_react.default.createElement(BodyExcerpt, {
        content: body.content || '',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.testResults.expandedRow.response_body.notRecorded",
        defaultMessage: "Body not recorded. Set index response body option to \"On Always\" in advanced options of monitor configuration to record body.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 15
        }
      })))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, (ping === null || ping === void 0 ? void 0 : (_ping$http2 = ping.http) === null || _ping$http2 === void 0 ? void 0 : (_ping$http2$response = _ping$http2.response) === null || _ping$http2$response === void 0 ? void 0 : _ping$http2$response.redirects) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_ping_redirects.PingRedirects, {
    monitorStatus: ping,
    showTitle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  })), (ping === null || ping === void 0 ? void 0 : (_ping$http3 = ping.http) === null || _ping$http3 === void 0 ? void 0 : (_ping$http3$response = _ping$http3.response) === null || _ping$http3$response === void 0 ? void 0 : _ping$http3$response.headers) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_headers.PingHeaders, {
    headers: ping === null || ping === void 0 ? void 0 : (_ping$http4 = ping.http) === null || _ping$http4 === void 0 ? void 0 : (_ping$http4$response = _ping$http4.response) === null || _ping$http4$response === void 0 ? void 0 : _ping$http4$response.headers,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: ping !== null && ping !== void 0 && ping.error ? 'danger' : 'primary',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }))));
};
exports.PingListExpandedRowComponent = PingListExpandedRowComponent;