"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualTestRunMode = ManualTestRunMode;
var _react = _interopRequireWildcard(require("react"));
var _use_run_once_errors = require("../hooks/use_run_once_errors");
var _browser_test_results = require("./browser_test_results");
var _simple_test_results = require("./simple_test_results");
var _use_monitor_by_id = require("../../../hooks/use_monitor_by_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/manual_test_run_mode/manual_test_run_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ManualTestRunMode({
  manualTestRun,
  onDone
}) {
  var _monitor$locations, _manualTestRun$errors;
  const monitor = (0, _use_monitor_by_id.useMonitorById)(manualTestRun.configId);
  const {
    expectPings
  } = (0, _use_run_once_errors.useRunOnceErrors)({
    testRunId: manualTestRun.testRunId,
    locations: (_monitor$locations = monitor === null || monitor === void 0 ? void 0 : monitor.locations) !== null && _monitor$locations !== void 0 ? _monitor$locations : [],
    errors: (_manualTestRun$errors = manualTestRun.errors) !== null && _manualTestRun$errors !== void 0 ? _manualTestRun$errors : []
  });
  if (!manualTestRun.testRunId || !monitor) return null;
  const isBrowserMonitor = monitor.type === 'browser';
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: manualTestRun.testRunId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_browser_test_results.BrowserTestRunResult, {
    name: monitor.name,
    expectPings: expectPings,
    onDone: onDone,
    testRunId: manualTestRun.testRunId,
    onProgress: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_simple_test_results.SimpleTestResults, {
    name: monitor.name,
    expectPings: expectPings,
    onDone: onDone,
    testRunId: manualTestRun.testRunId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }));
}