"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FAILED_TO_SCHEDULE = exports.BrowserTestRunResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_service = require("../../../../../utils/kibana_service");
var _use_browser_run_once_monitors = require("../hooks/use_browser_run_once_monitors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/manual_test_run_mode/browser_test_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BrowserTestRunResult = ({
  name,
  expectPings,
  onDone,
  testRunId,
  onProgress
}) => {
  const {
    summariesLoading,
    expectedSummariesLoaded,
    stepLoadingInProgress,
    checkGroupResults,
    retriesExceeded
  } = (0, _use_browser_run_once_monitors.useBrowserRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    const {
      coreStart,
      toasts
    } = _kibana_service.kibanaService;
    if (retriesExceeded) {
      toasts.addDanger({
        text: FAILED_TO_SCHEDULE,
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.manualTestRun.failedTest.name",
          defaultMessage: "Manual test run failed for {name}",
          values: {
            name
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 13
          }
        }), coreStart)
      }, {
        toastLifeTimeMs: 10000
      });
      onDone(testRunId);
    }
  }, [name, onDone, retriesExceeded, testRunId]);
  (0, _react.useEffect)(() => {
    if (expectedSummariesLoaded) {
      onDone(testRunId);
    }
  }, [onDone, expectedSummariesLoaded, testRunId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, checkGroupResults.map(checkGroupResult => {
    var _summaryDoc$error2, _summaryDoc$error2$me;
    const {
      checkGroupId,
      journeyStarted,
      summaryDoc,
      stepsLoading,
      steps,
      completedSteps
    } = checkGroupResult;
    const isStepsLoading = !summariesLoading && journeyStarted && summaryDoc && stepsLoading;
    const isStepsLoadingFailed = summaryDoc && !summariesLoading && !stepLoadingInProgress && steps.length === 0;
    if (completedSteps > 0) {
      onProgress(_i18n.i18n.translate('xpack.synthetics.monitorManagement.stepCompleted', {
        defaultMessage: '{stepCount, number} {stepCount, plural, one {step} other {steps}}  completed',
        values: {
          stepCount: completedSteps !== null && completedSteps !== void 0 ? completedSteps : 0
        }
      }));
    }
    if (isStepsLoading) {
      onProgress(LOADING_STEPS);
    }
    if (isStepsLoadingFailed) {
      var _summaryDoc$error$mes, _summaryDoc$error;
      // TODO: Add error toast
      onProgress((_summaryDoc$error$mes = summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error = summaryDoc.error) === null || _summaryDoc$error === void 0 ? void 0 : _summaryDoc$error.message) !== null && _summaryDoc$error$mes !== void 0 ? _summaryDoc$error$mes : FAILED_TO_RUN);
      // <EuiText color="danger">{summaryDoc?.error?.message ?? FAILED_TO_RUN}</EuiText>
    }
    if (isStepsLoadingFailed && summaryDoc !== null && summaryDoc !== void 0 && (_summaryDoc$error2 = summaryDoc.error) !== null && _summaryDoc$error2 !== void 0 && (_summaryDoc$error2$me = _summaryDoc$error2.message) !== null && _summaryDoc$error2$me !== void 0 && _summaryDoc$error2$me.includes('journey did not finish executing')) {
      // TODO: Add error toast
      // <StdErrorLogs checkGroup={summaryDoc.monitor.check_group} hideTitle={true} />;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: 'accordion-' + checkGroupId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 16
      }
    });
  }));
};
exports.BrowserTestRunResult = BrowserTestRunResult;
const FAILED_TO_RUN = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedRun', {
  defaultMessage: 'Failed to run steps'
});
const FAILED_TO_SCHEDULE = exports.FAILED_TO_SCHEDULE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedScheduling', {
  defaultMessage: 'Failed to get any results back for manual test run.'
});
const LOADING_STEPS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.loadingSteps', {
  defaultMessage: 'Loading steps...'
});