"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBrowserRunOnceMonitors = exports.useBrowserEsResults = void 0;
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_tick_tick = require("./use_tick_tick");
var _browser_steps_list = require("../../common/monitor_test_result/browser_steps_list");
var _constants = require("../../../../../../common/constants");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBrowserEsResults = ({
  testRunId,
  lastRefresh
}) => {
  return (0, _public.useEsSearch)((0, _public.createEsParams)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    sort: [{
      '@timestamp': 'desc'
    }],
    query: {
      bool: {
        filter: [{
          terms: {
            'synthetics.type': ['heartbeat/summary', 'journey/start']
          }
        }, {
          term: {
            test_run_id: testRunId
          }
        }]
      }
    },
    size: 1000
  }), [testRunId, lastRefresh], {
    name: 'TestRunData'
  });
};
exports.useBrowserEsResults = useBrowserEsResults;
const MAX_RETRIES = 25;
const useBrowserRunOnceMonitors = ({
  testRunId,
  skipDetails = false,
  expectSummaryDocs
}) => {
  const {
    refreshTimer,
    lastRefresh,
    clearTicks
  } = (0, _use_tick_tick.useTickTick)(5 * 1000);
  const [numberOfRetries, setNumberOfRetries] = (0, _react.useState)(0);
  const [checkGroupResults, setCheckGroupResults] = (0, _react.useState)(() => {
    return new Array(expectSummaryDocs).fill({
      checkGroupId: '',
      journeyStarted: false,
      steps: [],
      stepsLoading: false,
      completedSteps: 0
    }).map((emptyCheckGroup, index) => ({
      ...emptyCheckGroup,
      checkGroupId: `placeholder-check-group-${index}`
    }));
  });
  const lastUpdated = (0, _react.useRef)({
    checksum: '',
    time: Date.now()
  });
  const {
    data,
    loading: summariesLoading
  } = useBrowserEsResults({
    testRunId,
    lastRefresh
  });
  (0, _react.useEffect)(() => {
    const hits = data === null || data === void 0 ? void 0 : data.hits.hits;
    if (hits && hits.length > 0) {
      const allDocs = (hits !== null && hits !== void 0 ? hits : []).map(({
        _source
      }) => _source);
      const checkGroupsById = allDocs.filter(doc => {
        var _doc$synthetics, _doc$synthetics2;
        return ((_doc$synthetics = doc.synthetics) === null || _doc$synthetics === void 0 ? void 0 : _doc$synthetics.type) === 'journey/start' || ((_doc$synthetics2 = doc.synthetics) === null || _doc$synthetics2 === void 0 ? void 0 : _doc$synthetics2.type) === 'heartbeat/summary';
      }).reduce((acc, cur) => ({
        ...acc,
        [cur.monitor.check_group]: {
          checkGroupId: cur.monitor.check_group,
          journeyStarted: true,
          journeyDoc: cur,
          summaryDoc: null,
          steps: [],
          stepsLoading: false,
          completedSteps: 0
        }
      }), {});
      allDocs.forEach(step => {
        var _step$synthetics;
        if (((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : _step$synthetics.type) === 'heartbeat/summary') {
          checkGroupsById[step.monitor.check_group].summaryDoc = step;
        }
      });
      const checkGroups = Object.values(checkGroupsById);
      const finishedCheckGroups = checkGroups.filter(group => !!group.summaryDoc);
      if (finishedCheckGroups.length >= expectSummaryDocs) {
        clearInterval(refreshTimer);
      }
      replaceCheckGroupResults(checkGroups);
    } else {
      setNumberOfRetries(prevState => {
        const attempts = prevState + 1;
        if (attempts > MAX_RETRIES) {
          clearTicks();
        }
        return attempts;
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [expectSummaryDocs, data, refreshTimer]);

  // Loading steps for browser runs
  const checkGroupIds = checkGroupResults.map(({
    checkGroupId
  }) => checkGroupId);
  const checkGroupCheckSum = checkGroupIds.reduce((acc, cur) => acc + cur, '');
  const {
    loading: stepLoadingInProgress
  } = (0, _public.useFetcher)(() => {
    if (checkGroupIds.length && !skipDetails) {
      setCheckGroupResults(prevState => {
        return prevState.map(result => ({
          ...result,
          stepsLoading: true
        }));
      });
      return Promise.all(checkGroupIds.map(id => {
        return (0, _state.fetchBrowserJourney)({
          checkGroup: id
        }).then(stepsData => {
          updateCheckGroupResult(stepsData.checkGroup, {
            steps: stepsData.steps,
            completedSteps: stepsData.steps.filter(_browser_steps_list.isStepEnd).length
          });
          return stepsData;
        }).finally(() => {
          updateCheckGroupResult(id, {
            stepsLoading: false
          });
        });
      }));
    }
    return Promise.resolve(null);
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Synthetics folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [checkGroupCheckSum, setCheckGroupResults, lastRefresh]);

  // Whenever a new found document is fetched, update lastUpdated
  (0, _react.useEffect)(() => {
    const currentChecksum = getCheckGroupChecksum(checkGroupResults);
    if (checkGroupCheckSum !== lastUpdated.current.checksum) {
      // Mutating lastUpdated
      lastUpdated.current.checksum = currentChecksum;
      lastUpdated.current.time = Date.now();
    }
  }, [checkGroupResults, checkGroupCheckSum]);
  const updateCheckGroupResult = (id, result) => {
    setCheckGroupResults(prevState => {
      return prevState.map(r => {
        if (id !== r.checkGroupId) {
          return r;
        }
        return mergeCheckGroups(r, result);
      });
    });
  };
  const replaceCheckGroupResults = curCheckGroups => {
    const emptyCheckGroups = checkGroupResults.filter(group => group.checkGroupId.startsWith('placeholder-check-group'));

    // Padding the collection with placeholders so that rows could be shown on UI with loading state
    const paddedCheckGroups = curCheckGroups.length < expectSummaryDocs ? [...curCheckGroups, ...emptyCheckGroups.slice(-1 * (expectSummaryDocs - curCheckGroups.length))] : curCheckGroups;
    setCheckGroupResults(prevCheckGroups => {
      const newIds = paddedCheckGroups.map(({
        checkGroupId
      }) => checkGroupId);
      const newById = paddedCheckGroups.reduce((acc, cur) => ({
        ...acc,
        [cur.checkGroupId]: cur
      }), {});
      const oldById = prevCheckGroups.reduce((acc, cur) => ({
        ...acc,
        [cur.checkGroupId]: cur
      }), {});
      return newIds.map(id => mergeCheckGroups(oldById[id], newById[id]));
    });
  };
  return {
    data,
    retriesExceeded: numberOfRetries > MAX_RETRIES,
    summariesLoading,
    stepLoadingInProgress,
    expectedSummariesLoaded: checkGroupResults.filter(({
      summaryDoc
    }) => !!summaryDoc).length >= expectSummaryDocs,
    checkGroupResults,
    lastUpdated: lastUpdated.current.time
  };
};
exports.useBrowserRunOnceMonitors = useBrowserRunOnceMonitors;
function mergeCheckGroups(prev, curr) {
  var _prev$completedSteps, _curr$completedSteps, _prev$completedSteps2, _curr$steps, _prev$steps;
  // Once completed steps has been determined and shown, don't lower the number on UI due to re-fetch
  const completedSteps = curr.completedSteps ? Math.max((_prev$completedSteps = prev === null || prev === void 0 ? void 0 : prev.completedSteps) !== null && _prev$completedSteps !== void 0 ? _prev$completedSteps : 0, (_curr$completedSteps = curr.completedSteps) !== null && _curr$completedSteps !== void 0 ? _curr$completedSteps : 0) : (_prev$completedSteps2 = prev === null || prev === void 0 ? void 0 : prev.completedSteps) !== null && _prev$completedSteps2 !== void 0 ? _prev$completedSteps2 : 0;
  let steps = (_curr$steps = curr.steps) !== null && _curr$steps !== void 0 ? _curr$steps : [];
  if (steps.length === 0 && ((_prev$steps = prev === null || prev === void 0 ? void 0 : prev.steps) !== null && _prev$steps !== void 0 ? _prev$steps : []).length > 0) {
    steps = prev.steps;
  }
  return {
    ...(prev !== null && prev !== void 0 ? prev : {}),
    ...curr,
    steps,
    completedSteps
  };
}
function getCheckGroupChecksum(checkGroupResults) {
  return checkGroupResults.reduce((acc, cur) => {
    var _cur$journeyDoc$_id, _cur$journeyDoc, _cur$summaryDoc$_id, _cur$summaryDoc, _cur$steps;
    return acc + ((_cur$journeyDoc$_id = cur === null || cur === void 0 ? void 0 : (_cur$journeyDoc = cur.journeyDoc) === null || _cur$journeyDoc === void 0 ? void 0 : _cur$journeyDoc._id) !== null && _cur$journeyDoc$_id !== void 0 ? _cur$journeyDoc$_id : '') + ((_cur$summaryDoc$_id = cur === null || cur === void 0 ? void 0 : (_cur$summaryDoc = cur.summaryDoc) === null || _cur$summaryDoc === void 0 ? void 0 : _cur$summaryDoc._id) !== null && _cur$summaryDoc$_id !== void 0 ? _cur$summaryDoc$_id : '') + ((_cur$steps = cur === null || cur === void 0 ? void 0 : cur.steps) !== null && _cur$steps !== void 0 ? _cur$steps : []).reduce((stepAcc, {
      _id
    }) => stepAcc + _id, '');
  }, '');
}