"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTooltipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _waterfall_context = require("./context/waterfall_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_tooltip_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledText = (0, _common.euiStyled)(_eui.EuiText)`
  font-weight: bold;
`;
const StyledHorizontalRule = (0, _common.euiStyled)(_eui.EuiHorizontalRule)`
  background-color: ${props => props.theme.eui.euiColorDarkShade};
`;
const WaterfallTooltipContent = ({
  text,
  url,
  index
}) => {
  const {
    renderTooltipItem,
    metadata
  } = (0, _waterfall_context.useWaterfallContext)();
  // the passed index is base 1, so we need to subtract 1 to get the correct index
  const metadataEntry = metadata === null || metadata === void 0 ? void 0 : metadata[index - 1];
  const tooltipItems = metadataEntry === null || metadataEntry === void 0 ? void 0 : metadataEntry.networkItemTooltipProps;
  const showTooltip = metadataEntry === null || metadataEntry === void 0 ? void 0 : metadataEntry.showTooltip;
  if (!tooltipItems || !showTooltip) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 500,
      height: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, text), /*#__PURE__*/_react.default.createElement(StyledHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, tooltipItems.map((item, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, renderTooltipItem(item)))));
};
exports.WaterfallTooltipContent = WaterfallTooltipContent;