"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallMimeLegend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../common/network_data/types");
var _data_formatting = require("../../../common/network_data/data_formatting");
var _waterfall_legend_item = require("./waterfall_legend_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_header/waterfall_mime_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaterfallMimeLegend = ({
  activeFilters,
  setActiveFilters,
  showCustomMarks,
  setShowCustomMarks
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const addOrRemoveFilter = (0, _react.useCallback)(filter => {
    setActiveFilters(filters => {
      const updated = filters.includes(filter) ? filters.filter(f => f !== filter) : [...filters, filter];
      return updated.length === _types.MIME_FILTERS.length ? [] : updated;
    });
  }, [setActiveFilters]);
  const clearFilters = (0, _react.useCallback)(() => {
    setActiveFilters([]);
  }, [setActiveFilters]);
  const anyFilterApplied = activeFilters.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      height: 20,
      marginTop: 6,
      marginLeft: euiTheme.size.s
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, !anyFilterApplied ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, APPLY_FILTER_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    css: {
      gap: `min(3%, ${euiTheme.size.l})`,
      width: '100%',
      padding: euiTheme.size.s
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, _types.MIME_FILTERS.map(f => /*#__PURE__*/_react.default.createElement(_waterfall_legend_item.WaterfallLegendItem, {
    key: f.mimeType,
    id: f.mimeType,
    color: _data_formatting.colourPalette[f.mimeType],
    label: f.label,
    isClickable: true,
    isActive: !activeFilters.length || activeFilters.includes(f.mimeType),
    onClick: addOrRemoveFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: 24,
      width: '100%'
    },
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      maxWidth: 'fit-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, anyFilterApplied ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsWaterfallLegendButton",
    size: "xs",
    onClick: clearFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, CLEAR_FILTER_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsWaterfallCustomMarksButton",
    size: "xs",
    iconType: showCustomMarks ? 'eye' : 'eyeClosed',
    iconSize: "s",
    onClick: () => {
      setShowCustomMarks(!showCustomMarks);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, CUSTOM_MARKS_LABEL))));
};
exports.WaterfallMimeLegend = WaterfallMimeLegend;
const APPLY_FILTER_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.applyFilters.label', {
  defaultMessage: 'Select an item to apply filter'
});
const CLEAR_FILTER_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.clearFilters.label', {
  defaultMessage: 'Clear filters'
});
const CUSTOM_MARKS_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.customMarks.label', {
  defaultMessage: 'Custom marks'
});