"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChartContainer = exports.NO_DATA_TEXT = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../../state/network_events/selectors");
var _waterfall_chart_wrapper = require("./waterfall_chart_wrapper");
var _data_formatting = require("../../common/network_data/data_formatting");
var _use_step_waterfall_metrics = require("../use_step_waterfall_metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_chart_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_DATA_TEXT = exports.NO_DATA_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.waterfallNoData', {
  defaultMessage: 'No waterfall data could be found for this step'
});
const WaterfallChartContainer = ({
  checkGroup,
  stepIndex,
  activeStep
}) => {
  var _networkEvents2, _networkEvents$events;
  const _networkEvents = (0, _reactRedux.useSelector)(_selectors.networkEventsSelector);
  const networkEvents = (_networkEvents2 = _networkEvents[checkGroup !== null && checkGroup !== void 0 ? checkGroup : '']) === null || _networkEvents2 === void 0 ? void 0 : _networkEvents2[stepIndex];
  const hasEvents = (networkEvents === null || networkEvents === void 0 ? void 0 : (_networkEvents$events = networkEvents.events) === null || _networkEvents$events === void 0 ? void 0 : _networkEvents$events.length) > 0;
  const waterfallLoaded = networkEvents && !networkEvents.loading;
  const isWaterfallSupported = networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.isWaterfallSupported;
  const {
    metrics
  } = (0, _use_step_waterfall_metrics.useStepWaterfallMetrics)({
    checkGroup,
    stepIndex,
    hasNavigationRequest: networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.hasNavigationRequest
  });
  const data = (0, _react.useMemo)(() => {
    var _networkEvents$events2;
    return (0, _data_formatting.extractItems)((_networkEvents$events2 = networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.events) !== null && _networkEvents$events2 !== void 0 ? _networkEvents$events2 : []);
  }, [networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.events]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !waterfallLoaded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    "aria-label": _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.waterfall.loading', {
      defaultMessage: 'Waterfall chart loading'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }))), waterfallLoaded && !hasEvents && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, NO_DATA_TEXT)))), waterfallLoaded && hasEvents && isWaterfallSupported && /*#__PURE__*/_react.default.createElement(_waterfall_chart_wrapper.WaterfallChartWrapper, {
    data: data,
    markerItems: metrics,
    total: networkEvents.total,
    activeStep: activeStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }), waterfallLoaded && hasEvents && !isWaterfallSupported && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.synthetics.stepDetail.waterfallUnsupported.title",
      defaultMessage: "Waterfall chart unavailable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }),
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepDetail.waterfallUnsupported.description",
    defaultMessage: "The waterfall chart cannot be shown. You may be using an older version of the Synthetic Agent. Please check the version and consider upgrading.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })));
};
exports.WaterfallChartContainer = WaterfallChartContainer;