"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateLocationsTable = exports.MONITORS = exports.LEARN_MORE = exports.AGENT_POLICY_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _copy_name = require("./copy_name");
var _view_location_monitors = require("./view_location_monitors");
var _table_title = require("../../common/components/table_title");
var _tags_field = require("../components/tags_field");
var _contexts = require("../../../contexts");
var _empty_locations = require("./empty_locations");
var _permissions = require("../../common/components/permissions");
var _delete_location = require("./delete_location");
var _use_location_monitors = require("./hooks/use_location_monitors");
var _policy_name = require("./policy_name");
var _location_form = require("./location_form");
var _actions = require("../../../state/private_locations/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/private_locations/locations_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivateLocationsTable = ({
  deleteLoading,
  onDelete,
  onEdit,
  privateLocations
}) => {
  var _services$spaces$ui$c, _services$spaces;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const {
    locationMonitors,
    loading
  } = (0, _use_location_monitors.useLocationMonitors)();
  const {
    canSave,
    canManagePrivateLocations
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const LazySpaceList = (_services$spaces$ui$c = (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.ui.components.getSpaceList) !== null && _services$spaces$ui$c !== void 0 ? _services$spaces$ui$c : () => null;
  const tagsList = privateLocations.reduce((acc, item) => {
    const tags = item.tags || [];
    return new Set([...acc, ...tags]);
  }, new Set());
  const columns = [{
    field: 'label',
    name: _location_form.LOCATION_NAME_LABEL,
    render: label => /*#__PURE__*/_react.default.createElement(_copy_name.CopyName, {
      text: label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 34
      }
    })
  }, {
    field: 'monitors',
    name: MONITORS,
    render: (monitors, item) => /*#__PURE__*/_react.default.createElement(_view_location_monitors.ViewLocationMonitors, {
      count: monitors,
      locationName: item.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    })
  }, {
    field: 'agentPolicyId',
    name: AGENT_POLICY_LABEL,
    render: agentPolicyId => /*#__PURE__*/_react.default.createElement(_policy_name.PolicyName, {
      agentPolicyId: agentPolicyId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 42
      }
    })
  }, {
    name: _tags_field.TAGS_LABEL,
    field: 'tags',
    sortable: true,
    render: val => {
      const tags = val !== null && val !== void 0 ? val : [];
      if (tags.length === 0) {
        return '--';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }, tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: tag,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 17
        }
      }, tag))));
    }
  }, {
    name: 'Spaces',
    field: 'spaces',
    sortable: true,
    render: spaces => {
      return /*#__PURE__*/_react.default.createElement(LazySpaceList, {
        namespaces: spaces,
        behaviorContext: "outside-space",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 16
        }
      });
    }
  }, {
    name: ACTIONS_LABEL,
    actions: [{
      name: EDIT_LOCATION,
      description: EDIT_LOCATION,
      isPrimary: true,
      'data-test-subj': 'action-edit',
      onClick: onEdit,
      icon: 'pencil',
      type: 'icon'
    }, {
      name: DELETE_LOCATION,
      description: DELETE_LOCATION,
      render: item => /*#__PURE__*/_react.default.createElement(_delete_location.DeleteLocation, {
        id: item.id,
        label: item.label,
        locationMonitors: locationMonitors,
        onDelete: onDelete,
        loading: deleteLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 13
        }
      }),
      isPrimary: true,
      'data-test-subj': 'action-delete'
    }]
  }];
  const items = privateLocations.map(location => {
    var _locationMonitors$fin, _locationMonitors$fin2;
    return {
      ...location,
      monitors: (_locationMonitors$fin = locationMonitors === null || locationMonitors === void 0 ? void 0 : (_locationMonitors$fin2 = locationMonitors.find(l => l.id === location.id)) === null || _locationMonitors$fin2 === void 0 ? void 0 : _locationMonitors$fin2.count) !== null && _locationMonitors$fin !== void 0 ? _locationMonitors$fin : 0
    };
  });
  const openFlyout = () => dispatch((0, _actions.setIsPrivateLocationFlyoutVisible)(true));
  const renderToolRight = () => {
    return [/*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canSave,
      canManagePrivateLocations: canManagePrivateLocations,
      key: "addPrivateLocationButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": 'addPrivateLocationButton',
      isLoading: loading,
      disabled: !canSave || !canManagePrivateLocations,
      onClick: openFlyout,
      iconType: "plusInCircle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, ADD_LABEL))];
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, _empty_locations.START_ADDING_LOCATIONS_DESCRIPTION, " ", /*#__PURE__*/_react.default.createElement(_empty_locations.PrivateLocationDocsLink, {
    label: LEARN_MORE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 46
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: 'id',
    tableLayout: "auto",
    tableCaption: PRIVATE_LOCATIONS,
    items: items,
    columns: columns,
    childrenBetween: /*#__PURE__*/_react.default.createElement(_table_title.TableTitle, {
      total: items.length,
      label: PRIVATE_LOCATIONS,
      pageIndex: pageIndex,
      pageSize: pageSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }),
    pagination: {
      pageSize,
      pageIndex
    },
    onTableChange: ({
      page
    }) => {
      var _page$index, _page$size;
      setPageIndex((_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : 0);
      setPageSize((_page$size = page === null || page === void 0 ? void 0 : page.size) !== null && _page$size !== void 0 ? _page$size : 10);
    },
    search: {
      toolsRight: renderToolRight(),
      box: {
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'tags',
        name: _tags_field.TAGS_LABEL,
        multiSelect: true,
        options: [...tagsList].map(tag => ({
          value: tag,
          name: tag,
          view: tag
        }))
      }]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }));
};
exports.PrivateLocationsTable = PrivateLocationsTable;
const PRIVATE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocations', {
  defaultMessage: 'Private locations'
});
const ACTIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.actions', {
  defaultMessage: 'Actions'
});
const MONITORS = exports.MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitors', {
  defaultMessage: 'Monitors'
});
const AGENT_POLICY_LABEL = exports.AGENT_POLICY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentPolicy', {
  defaultMessage: 'Agent Policy'
});
const DELETE_LOCATION = _i18n.i18n.translate('xpack.synthetics.settingsRoute.privateLocations.deleteLabel', {
  defaultMessage: 'Delete private location'
});
const EDIT_LOCATION = _i18n.i18n.translate('xpack.synthetics.settingsRoute.privateLocations.editLabel', {
  defaultMessage: 'Edit private location'
});
const ADD_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createLocation', {
  defaultMessage: 'Create location'
});
const LEARN_MORE = exports.LEARN_MORE = _i18n.i18n.translate('xpack.synthetics.privateLocations.learnMore.label', {
  defaultMessage: 'Learn more.'
});