"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Unprivileged = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/data_retention/unprivileged.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Unprivileged = ({
  hideIlmMessage = false
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    color: "plain",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.dataRetention.unprivileged.unprivilegedTitle",
      defaultMessage: "Missing privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.params.unprivileged.unprivilegedDescription",
      defaultMessage: "You need additional privileges to view Synthetics app data usage and retention settings. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "syntheticsUnprivilegedLearnMoreLink",
          href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.synthetics.featureRoles,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.projectDelete.docsLink', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      css: (0, _react2.css)`
            text-align: initial;
          `,
      children: `\n- ${INDEX_PRIVILEGES} ${hideIlmMessage ? '' : ` \n- ${CLUSTER_PRIVILEGES}`}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
};
exports.Unprivileged = Unprivileged;
const INDEX_PRIVILEGES = _i18n.i18n.translate('xpack.synthetics.dataRetention.unprivileged.index', {
  defaultMessage: '`read`, `monitor` on the following Elasticsearch indices: `synthetics-*`'
});
const CLUSTER_PRIVILEGES = _i18n.i18n.translate('xpack.synthetics.dataRetention.unprivileged.cluster', {
  defaultMessage: '`read_ilm`, `monitor` to view and `manage_ilm` to manage ILM policies on the Elasticsearch cluster.'
});