"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAGS_LABEL = void 0;
exports.TagsField = TagsField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/components/tags_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TagsField({
  tagsList,
  control,
  errors,
  isDisabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: TAGS_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "tags",
    control: control,
    render: ({
      field
    }) => {
      var _field$value$map, _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
        isDisabled: isDisabled,
        fullWidth: true,
        "aria-label": TAGS_LABEL,
        placeholder: TAGS_LABEL,
        isInvalid: !!(errors !== null && errors !== void 0 && errors.tags),
        selectedOptions: (_field$value$map = (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.map(tag => ({
          label: tag,
          value: tag
        }))) !== null && _field$value$map !== void 0 ? _field$value$map : [],
        options: tagsList.map(tag => ({
          label: tag,
          value: tag
        })),
        onCreateOption: newTag => {
          var _field$value2;
          field.onChange([...((_field$value2 = field.value) !== null && _field$value2 !== void 0 ? _field$value2 : []), newTag]);
        }
      }, field, {
        onChange: selectedTags => {
          field.onChange(selectedTags.map(tag => tag.value));
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 11
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
}
const TAGS_LABEL = exports.TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.tagsLabel', {
  defaultMessage: 'Tags'
});