"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertingDefaults = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _selectors = require("../../../../state/settings/selectors");
var _api = require("../../../../state/settings/api");
var _actions = require("../../../../state/settings/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/alerting_defaults/hooks/use_alerting_defaults.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAlertingDefaults = () => {
  const {
    data: actionTypes
  } = (0, _public.useFetcher)(() => (0, _api.fetchActionTypes)(), []);
  const {
    connectors,
    connectorsLoading,
    loading,
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    defaultConnectors
  } = settings || {};
  const {
    actionTypeRegistry
  } = (0, _public2.useKibana)().services.triggersActionsUi;
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getConnectorsAction.get());
  }, [dispatch]);
  const options = (connectors !== null && connectors !== void 0 ? connectors : []).filter(action => (actionTypes !== null && actionTypes !== void 0 ? actionTypes : []).find(type => type.id === action.actionTypeId)).map(connectorAction => ({
    value: connectorAction.id,
    label: connectorAction.name,
    'data-test-subj': connectorAction.name,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: actionTypeRegistry.get(connectorAction.actionTypeId).iconClass,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    })
  }));
  return {
    options,
    actionTypes,
    connectors,
    connectorsLoading,
    settingsLoading: loading,
    defaultConnectors
  };
};
exports.useAlertingDefaults = useAlertingDefaults;