"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _actions = require("../../../state/settings/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/alerting_defaults/add_connector_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddConnectorFlyout = ({
  focusInput,
  isDisabled
}) => {
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react.useState)(false);
  const {
    services: {
      application,
      triggersActionsUi: {
        getAddConnectorFlyout
      }
    }
  } = (0, _public.useKibana)();
  const canEdit = !!(application !== null && application !== void 0 && application.capabilities.actions.save);
  const dispatch = (0, _reactRedux.useDispatch)();
  const ConnectorAddFlyout = (0, _react.useMemo)(() => getAddConnectorFlyout({
    onClose: () => {
      dispatch(_actions.getConnectorsAction.get());
      setAddFlyoutVisibility(false);
      focusInput();
    },
    featureId: 'uptime'
  }), [dispatch, focusInput, getAddConnectorFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addFlyoutVisible ? ConnectorAddFlyout : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "createConnectorButton",
    onClick: () => setAddFlyoutVisibility(true),
    size: "s",
    isDisabled: isDisabled || !canEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerts.settings.addConnector",
    defaultMessage: "Add connector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })));
};
exports.AddConnectorFlyout = AddConnectorFlyout;