"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _overview_status = require("../../../state/overview_status");
var _disabled_callout = require("../management/disabled_callout");
var _filter_group = require("../common/monitor_filters/filter_group");
var _overview_alerts = require("./overview/overview_alerts");
var _hooks = require("../../../hooks");
var _state = require("../../../state");
var _service_locations = require("../../../state/service_locations");
var _constants = require("../../../../../../common/constants");
var _use_monitor_list = require("../hooks/use_monitor_list");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _overview_grid = require("./overview/overview_grid");
var _overview_status2 = require("./overview/overview_status");
var _quick_filters = require("./overview/quick_filters");
var _search_field = require("../common/search_field");
var _no_monitors_found = require("../common/no_monitors_found");
var _overview_errors = require("./overview/overview_errors/overview_errors");
var _alerting_callout = require("../../common/alerting_callout/alerting_callout");
var _use_synthetics_page_ready = require("../../../hooks/use_synthetics_page_ready");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'overview'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'overview',
    delay: 15000
  });
  (0, _use_breadcrumbs.useOverviewBreadcrumbs)();
  const {
    view
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    loading: locationsLoading,
    locationsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _use_synthetics_page_ready.useSyntheticsPageReady)({
    meta: {
      description: '[ttfmp_synthetics] Synthetics overview page has loaded monitor data.'
    }
  });
  (0, _react.useEffect)(() => {
    if (!locationsLoading && !locationsLoaded) {
      dispatch((0, _service_locations.getServiceLocations)());
    }
  }, [dispatch, locationsLoaded, locationsLoading]);
  const {
    isEnabled,
    loading: enablementLoading
  } = (0, _hooks.useEnablement)();
  const {
    allConfigs,
    loaded: overviewLoaded
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    loading: monitorsLoading,
    loaded: monitorsLoaded,
    handleFilterChange,
    absoluteTotal
  } = (0, _use_monitor_list.useMonitorList)();
  const hasNoMonitors = !search && !enablementLoading && monitorsLoaded && absoluteTotal === 0;
  if (hasNoMonitors && !monitorsLoading && isEnabled) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.GETTING_STARTED_ROUTE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  if (!isEnabled && hasNoMonitors) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.MONITORS_ROUTE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  }
  const hasMonitors = !(monitorsLoaded && overviewLoaded && (allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.length) === 0);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    total: absoluteTotal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alerting_callout.AlertingCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_field.SearchField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_quick_filters.QuickFilters, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    handleFilterChange: handleFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), hasMonitors ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_status2.OverviewStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: {
      minWidth: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_errors.OverviewErrors, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: {
      minWidth: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_alerts.OverviewAlerts, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_overview_grid.OverviewGrid, {
    view: view,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }));
};
exports.OverviewPage = OverviewPage;