"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _overview = require("../../../../state/overview");
var _sort_menu = require("./sort_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/sort_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SortFields = () => {
  const {
    pageState: {
      sortOrder,
      sortField
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    asc,
    desc,
    label
  } = getOrderContent(sortField);
  const handleSortChange = payloadAction => {
    dispatch(payloadAction);
  };
  const orderByOptions = [{
    label: asc,
    value: 'asc',
    checked: sortOrder === 'asc',
    onClick: () => {
      handleSortChange((0, _overview.setOverviewPageStateAction)({
        sortOrder: 'asc'
      }));
    }
  }, {
    label: desc,
    value: 'desc',
    checked: sortOrder === 'desc',
    onClick: () => {
      handleSortChange((0, _overview.setOverviewPageStateAction)({
        sortOrder: 'desc'
      }));
    }
  }];
  const sortByOptions = [{
    label: STATUS_LABEL,
    value: 'status',
    checked: sortField === 'status',
    defaultSortOrder: 'asc',
    onClick: () => {
      handleSortChange((0, _overview.setOverviewPageStateAction)({
        sortField: 'status',
        sortOrder: 'asc'
      }));
    }
  }, {
    label: ALPHABETICAL_LABEL,
    value: `${_runtime_types.ConfigKey.NAME}.keyword`,
    checked: sortField === `${_runtime_types.ConfigKey.NAME}.keyword`,
    defaultSortOrder: 'asc',
    onClick: () => {
      handleSortChange((0, _overview.setOverviewPageStateAction)({
        sortField: `${_runtime_types.ConfigKey.NAME}.keyword`,
        sortOrder: 'asc'
      }));
    }
  }, {
    label: LAST_MODIFIED_LABEL,
    value: 'updated_at',
    checked: sortField === 'updated_at',
    defaultSortOrder: 'desc',
    onClick: () => {
      handleSortChange((0, _overview.setOverviewPageStateAction)({
        sortField: 'updated_at',
        sortOrder: 'desc'
      }));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, SORT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "syntheticsOverviewSortButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sort_menu.SortMenu, {
    sortOptions: sortByOptions,
    orderOptions: orderByOptions,
    sortField: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  })))));
};
exports.SortFields = SortFields;
const getOrderContent = sortField => {
  switch (sortField) {
    case `${_runtime_types.ConfigKey.NAME}.keyword`:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: ALPHABETICAL_LABEL
      };
    case 'updated_at':
      return {
        asc: SORT_UPDATED_ASC,
        desc: SORT_UPDATED_DESC,
        label: LAST_MODIFIED_LABEL
      };
    case 'status':
      return {
        asc: SORT_STATUS_ASC,
        desc: SORT_STATUS_DESC,
        label: STATUS_LABEL
      };
    default:
      return {
        asc: ASCENDING_LABEL,
        desc: DESCENDING_LABEL,
        label: ''
      };
  }
};
const SORT_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.sort.title', {
  defaultMessage: 'Sort by'
});
const SORT_ALPHABETICAL_ASC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.alphabetical.asc', {
  defaultMessage: 'A -> Z',
  description: 'Describes ascending alphabetical sort order'
});
const SORT_ALPHABETICAL_DESC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.alphabetical.desc', {
  defaultMessage: 'Z -> A',
  description: 'Describes descending alphabetical sort order'
});
const SORT_UPDATED_ASC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.lastModified.asc', {
  defaultMessage: 'Oldest first'
});
const SORT_UPDATED_DESC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.lastModified.desc', {
  defaultMessage: 'Newest first'
});
const SORT_STATUS_ASC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.status.asc', {
  defaultMessage: 'Down first'
});
const SORT_STATUS_DESC = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.status.desc', {
  defaultMessage: 'Up first'
});
const ASCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.ascending.label', {
  defaultMessage: 'Ascending'
});
const DESCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.descending.label', {
  defaultMessage: 'Descending'
});
const STATUS_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.status.label', {
  defaultMessage: 'Status'
});
const ALPHABETICAL_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.alphabetical.label', {
  defaultMessage: 'Alphabetical'
});
const LAST_MODIFIED_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.lastModified.label', {
  defaultMessage: 'Last modified'
});